<article class="post-article single-post-article">
    <?php if ($has_images) : ?>
        <div class="list-single-main-media fl-wrap">
            <div class="single-slider-wrap <?= count($post->images()) < 2 ? 'single-image-slider' : null ?>">
                <div class="single-slider fl-wrap">
                    <div class="swiper-container" dir="rtl">
                        <div class="swiper-wrapper lightgallery">
                            <?php foreach ($post->images() as $image) : ?>
                                <div class="swiper-slide hov_zoom">
                                    <img src="<?= imageNameForSize($image, 'main') ?>" alt="<?= $post->TITLE ?>">
                                    <a href="<?= imageNameForSize($image, 'large') ?>" class="box-media-zoom popup-image">
                                        <i class="fal fa-search"></i>
                                    </a>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <div class="listing-carousel_pagination">
                            <div class="listing-carousel_pagination-wrap">
                                <div class="ss-slider-pagination"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ss-slider-cont ss-slider-cont-prev color2-bg"><i class="fal fa-long-arrow-left"></i></div>
                <div class="ss-slider-cont ss-slider-cont-next color2-bg"><i class="fal fa-long-arrow-right"></i></div>
            </div>
        </div>
    <?php endif; ?>
    <div class="list-single-main-item fl-wrap block_box">
        <h2 class="post-opt-title level">
            <a href="<?= $post->viewLink() ?>"><?= $post->TITLE ?></a>

            <?php if ($current_page->setting('enable-voting') === 'YES') : ?>
                <div class="like-actions">
                    <a href="javascript:" class="like <?= $post->hasBeenVotedByCurrentVisitor() ? 'disabled' : '' ?>" data-action="like" title="Like"><i class="fal fa-thumbs-up"></i> <span class="count"><?= $post->likes() ?></span></a>
                    <a href="javascript:" class="dislike <?= $post->hasBeenVotedByCurrentVisitor() ? 'disabled' : '' ?>" data-action="dislike" title="Dislike"><i class="fal fa-thumbs-down"></i><span class="count"><?= $post->dislikes() ?></span></a>
                </div>
            <?php endif; ?>
        </h2>
        <div class="post-opt">
            <ul class="no-list-style">
                <li><i class="fal fa-calendar"></i> <span><?= $post->showDate() ?></span></li>
                <li><i class="fal fa-eye"></i> <span><?php _e('VIEWS_COUNT', false, ['{%1%}' => number_format($post->views)]) ?></span></li>
                <li><i class="fal fa-tags"></i> <a href="<?= blogRoutes('category', [$post->CATEGORY_ID, $post->CATEGORY_SLUG]) ?>"><?= $post->categoryName() ?></a> </li>
            </ul>
        </div>
        <span class="fw-separator"></span>
        <div class="clearfix"></div>

        <div class="post-description">
            <?= $post->POST_TEXT ?>
        </div>

        <?php if (! empty($tags) & count($tags) > 0) : ?>
            <span class="fw-separator"></span>
            <div class="list-single-tags tags-stylwrap">
                <span class="tags-title"><i class="fas fa-tag"></i> <?php _e('TAGS') ?> </span>
                <?php
                /** @var App\Tag $tag */
                foreach ($tags as $tag) {
                    echo "<a href='{$tag->viewLink()}' target='_blank'>{$tag->TAG_NAME}</a>";
                }
                ?>
            </div>
        <?php endif; ?>

    </div>
</article>

<?php if ($current_page->setting('show-prev-next-posts') === 'YES') : ?>
    <div class="post-nav-wrap fl-wrap">
        <?php if ($prev_post = $post->prevPost()) :  ?>
            <a class="post-nav post-nav-prev" href="<?= $prev_post->viewLink() ?>">
                <span class="post-nav-img"><img src="<?= $prev_post->featuredImage('mini') ?>" alt="<?= $prev_post->TITLE ?>"></span>
                <span class="post-nav-text"><strong><?php _e('PREV_POST') ?></strong><br><span><?= $prev_post->TITLE ?></span></span>
            </a>
        <?php endif; ?>
        <?php if ($next_post = $post->nextPost()) : ?>
            <a class="post-nav post-nav-next" href="<?= $next_post->viewLink() ?>">
                <span class="post-nav-img"><img src="<?= $next_post->featuredImage('mini') ?>" alt="<?= $next_post->TITLE ?>"></span>
                <span class="post-nav-text"><strong><?php _e('NEXT_POST') ?></strong> <br><span><?= $next_post->TITLE ?></span></span>
            </a>
        <?php endif; ?>
    </div>
<?php endif; ?>

<?php
if (! $printable && $current_page->setting('show-comments') === 'YES') {
    $item = $post;
    include('includes/theme/components/_comments.php');
}
?>