<?php foreach ($resource_items as $post) : ?>

    <article class="post-article">
        <div class="list-single-main-item fl-wrap block_box">
            <div class='col-sm-5 col-xs-12 list-single-main-media'>
                <img loading="lazy" src="<?= $post->featuredImage('thumb') ?>" class="respimg" alt="<?= strip_tags($post->TITLE) ?>">
            </div>
            <div class='col-sm-7 col-xs-12 blog-item-text pl-0'>
                <h2 class="post-opt-title"><a href="<?= $post->viewLink() ?>"><?= strip_tags($post->TITLE) ?></a></h2>
                <div class="post-opt">
                    <ul class="no-list-style">
                        <li><i class="fal fa-calendar"></i> <span><?= $post->showDate() ?></span></li>
                        <li><i class="fal fa-eye"></i> <span> <?php _e('VIEWS_COUNT', false, ['{%1%}' => number_format($post->views)]) ?> </span> </li>
                        <li><i class="fal fa-code-branch"></i> <a href="<?= blogRoutes('category', [$post->CATEGORY_ID, $post->CATEGORY_SLUG]) ?>"> <?= $post->categoryName() ?> </a></li>
                    </ul>
                </div>
                <span class="fw-separator"></span>
                <div class="clearfix"></div>

                <p><?= $post->shortDescription() ?></p>

            </div>

            <a href="<?= $post->viewLink() ?>" class="btn  color2-bg float-btn"><?= _e('READ_MORE', true) ?> <i class="fal fa-angle-left"></i></a>
        </div>
    </article>

<?php endforeach; ?>

<?php include('includes/core/components/_pagination.php'); ?>