<div id="wrapper">
    <div class="content">
        <section class="auth-page small-padding" >

            <div class="container">
                <div class="row">
                    <div class="col-md-4 col-sm-7 col-xs-12">

                        <?php session()->showAlert() ?>

                        <div class="form-message-placeholder colorful"></div>

                        <div class="auth-form-wrapper">
                            <div class="auth-title">
                                <h2> <?php _e('RESET_PASSWORD') ?> </h2>
                                <small><?php _e('RESET_PASSWORD_PAGE_DESCRIPTION') ?></small>
                            </div>

                            <form method="post" action="<?= resetPasswordRoot() ?>" class="auth-form darker-form" id="reset-password-form">

                                <?= csrf_field() ?>

                                <div class="col-sm-12 p-0 form-div">
                                    <div class="form-group form-group--float form-group--icon">
                                        <input type="password" id="password" name="password" class="form-control">
                                        <span class="input-icon-addon top-3"> <i class="fa fa-lock"></i> </span>
                                        <label for="password"><?php _e('PASSWORD') ?></label>
                                        <p class="help-block"></p>
                                    </div>
                                </div>

                                <div class="col-sm-12 p-0 form-div">
                                    <div class="form-group form-group--float form-group--icon">
                                        <input type="password" id="password_confirm" name="password_confirm" class="form-control">
                                        <span class="input-icon-addon top-3"> <i class="fa fa-lock"></i> </span>
                                        <label for="password_confirm"><?php _e('PASSWORD_CONFIRMATION') ?></label>
                                        <p class="help-block"></p>
                                    </div>
                                </div>

                                <?php if (isImageCaptcha()) : ?>
                                    <div class="image-captcha form-div">
                                        <img src="<?= captcha()->show('reset-password') ?>" id="reset_password_captcha" alt="reset password captcha">
                                        <div class="captcha-update-handler">
                                            <i class="fa fa-repeat" data-click-updates-captcha data-namespace="reset-password" data-target="#reset_password_captcha"></i>
                                        </div>
                                    </div>
                                    <div class="col-xs-12 p-0 form-div">
                                        <div class="form-group form-group--float form-group--icon">
                                            <input type="text" id="captcha" name="captcha" class="form-control captcha-field">
                                            <span class="input-icon-addon top-3"> <i class="fa fa-shield-alt"></i> </span>
                                            <label for="captcha"><?php _e('CAPTCHA_CODE') ?></label>
                                            <p class="help-block"></p>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div class="col-sm-12 p-0 form-div">
                                    <div class="clearfix"></div>

                                    <?php if (isRecaptcha()) : ?>
                                        <div class="g-recaptcha" id="recaptcha"></div>
                                        <div class="mini-next-line"></div>
                                    <?php endif; ?>

                                    <div class="text-center">
                                        <input type="hidden" name="forgot_token" value="<?= session()->get(config('forgot_password/token_session')) ?>">
                                        <input type="hidden" name="forgot_username" value="<?= session()->get(config('forgot_password/username_session')) ?>">
                                        <button type="submit" class="btn float-btn color2-bg" data-default-text="<?php _e('CHANGE_PASSWORD') ?>"> <?php _e('CHANGE_PASSWORD') ?> <i class="fas fa-caret-left"></i></button>
                                    </div>
                                </div>

                            </form>

                        </div>

                    </div>
                </div>
            </div>

        </section>
    </div>
</div>