<div id="wrapper">
    <div class="content">
        <section class="auth-page small-padding" >

            <div class="container">
                <div class="row">
                    <div class="col-md-4 col-sm-7 col-xs-12">

                        <?php session()->showAlert() ?>

                        <div class="form-message-placeholder colorful">

                        </div>

                        <div class="auth-form-wrapper">
                            <div class="auth-title level">
                                <h2> <?php _e('REGISTER') ?> </h2>
                                <a href="<?= loginLink() ?>"><?php _e('ALREADY_REGISTERED') ?></a>
                            </div>

                            <form method="post" action="<?= registerLink() ?>" class="auth-form darker-form" id="register-form">

                                <?= csrf_field() ?>

                                <div class="col-sm-12 p-0 form-div">
                                    <div class="form-group form-group--float form-group--icon">
                                        <input type="text" id="register_param" name="register_param" class="form-control">
                                        <span class="input-icon-addon top-3"> <i class="<?= usernameIcon() ?>"></i> </span>
                                        <label for="register_param"><?= usernameTitle() ?></label>
                                        <p class="help-block"></p>
                                    </div>
                                </div>

                                <div class="col-sm-12 p-0 form-div">
                                    <div class="form-group form-group--float form-group--icon">
                                        <input type="password" id="password" name="password" class="form-control">
                                        <span class="input-icon-addon top-3"> <i class="fa fa-lock"></i> </span>
                                        <label for="password"><?php _e('PASSWORD') ?></label>
                                        <span class="input-icon-addon password-toggle"><i class="fa fa-eye"></i></span>
                                        <p class="help-block"></p>
                                    </div>
                                </div>

                                <div class="col-sm-12 p-0 form-div">
                                    <div class="form-group form-group--float form-group--icon">
                                        <input type="password" id="password_confirm" name="password_confirm" class="form-control">
                                        <span class="input-icon-addon top-3"> <i class="fa fa-lock"></i> </span>
                                        <label for="password_confirm"><?php _e('PASSWORD_CONFIRMATION') ?></label>
                                        <p class="help-block"></p>
                                    </div>
                                </div>

                                <?php if ($current_page->setting('show-referer-field') === 'YES') : ?>
                                    <div class="col-sm-12 p-0 form-div">
                                        <div class="form-group form-group--float form-group--icon">
                                            <input type="text" id="referer_id" name="referer_id" class="form-control">
                                            <span class="input-icon-addon top-3"> <i class="fa fa-user"></i> </span>
                                            <label for="referer_id"><?php _e('REFERER_CODE') ?></label>
                                            <p class="help-block"></p>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <?php if (isImageCaptcha()) : ?>
                                    <div class="image-captcha form-div">
                                        <img src="<?= captcha()->show('register') ?>" id="register_captcha" alt="login captcha">
                                        <div class="captcha-update-handler">
                                            <i class="fa fa-repeat" data-click-updates-captcha data-namespace="register" data-target="#register_captcha"></i>
                                        </div>
                                    </div>
                                    <div class="col-xs-12 p-0 form-div">
                                        <div class="form-group form-group--float form-group--icon">
                                            <input type="text" id="captcha" name="captcha" class="form-control captcha-field">
                                            <span class="input-icon-addon top-3"> <i class="fa fa-shield-alt"></i> </span>
                                            <label for="captcha"><?php _e('CAPTCHA_CODE') ?></label>
                                            <p class="help-block"></p>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div class="clearfix"></div>

                                <div class="col-sm-12 p-0 form-div">

                                    <?php if (isRecaptcha()) : ?>
                                        <div class="g-recaptcha" id="register-recaptcha"></div>
                                        <div class="mini-next-line"></div>
                                    <?php endif; ?>

                                    <div class="text-center">
                                        <button type="submit" class="btn float-btn color2-bg" data-default-text="<?php _e('REGISTER') ?>"> <?php _e('REGISTER') ?> <i class="fas fa-caret-left"></i></button>
                                    </div>
                                </div>

                            </form>
                            <div class="auth-form-extra-links">
                                <div class="extra-link">
                                    <a href="<?= loginLink() ?>">قبلا ثبت نام کرده اید؟</a>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </section>
    </div>
</div>

<script>
    var GLOBE__username_type = "<?php echo usernameType() ?>";
</script>