<div id="wrapper">
    <div class="content">
        <section class="auth-page small-padding" >

            <div class="container">
                <div class="row">
                    <div class="col-md-4 col-sm-7 col-xs-12">

                        <?php session()->showAlert() ?>

                        <div class="form-message-placeholder colorful"></div>

                        <div class="auth-form-wrapper">
                            <div class="auth-title level">
                                <h2> <?php _e('LOGIN') ?> </h2>
                                <a href="<?= registerLink() ?>"><?php _e('NOT_REGISTERED_YET') ?></a>
                            </div>

                            <form method="post" action="<?= loginLink() ?>" class="auth-form darker-form" id="login-form">

                                <?= csrf_field() ?>

                                <div class="col-sm-12 p-0 form-div">
                                    <div class="form-group form-group--float form-group--icon">
                                        <input type="text" id="username" name="username" class="form-control">
                                        <span class="input-icon-addon top-3"> <i class="fa fa-user"></i> </span>
                                        <label for="username"><?php _e('MOBILE_OR_EMAIL') ?></label>
                                        <p class="help-block"></p>
                                    </div>
                                </div>

                                <div class="col-sm-12 p-0 form-div">
                                    <div class="form-group form-group--float form-group--icon">
                                        <input type="password" id="password" name="password" class="form-control">
                                        <span class="input-icon-addon top-3"> <i class="fa fa-lock"></i> </span>
                                        <label for="password"><?php _e('PASSWORD') ?></label>
                                        <span class="input-icon-addon password-toggle"><i class="fa fa-eye"></i></span>
                                        <p class="help-block"></p>
                                    </div>
                                </div>

                                <?php if (isImageCaptcha()) : ?>
                                    <div class="image-captcha form-div">
                                        <img src="<?= captcha()->show('login') ?>" id="login_captcha" alt="login captcha">
                                        <div class="captcha-update-handler">
                                            <i class="fa fa-repeat" data-click-updates-captcha data-namespace="login" data-target="#login_captcha"></i>
                                        </div>
                                    </div>
                                    <div class="col-xs-12 p-0 form-div">
                                        <div class="form-group form-group--float form-group--icon">
                                            <input type="text" id="captcha" name="captcha" class="form-control captcha-field">
                                            <span class="input-icon-addon top-3"> <i class="fa fa-shield-alt"></i> </span>
                                            <label for="captcha"><?php _e('CAPTCHA_CODE') ?></label>
                                            <p class="help-block"></p>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div class="clearfix"></div>

                                <div class="col-sm-12 p-0 form-div">

                                    <div class="filter-tags">
                                        <input type="checkbox" name="remember" id="remember">
                                        <label for="remember"> <?= _e('REMEMBER_ME') ?> </label>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>

                                <div class="col-sm-12 p-0 form-div">

                                    <?php if (isRecaptcha()) : ?>
                                        <div class="g-recaptcha" id="login-recaptcha"></div>
                                        <div class="mini-next-line"></div>
                                    <?php endif; ?>

                                </div>

                                <div class="text-center">
                                    <button type="submit" class="btn float-btn color2-bg" data-default-text="<?php _e('LOGIN') ?>"> <?php _e('LOGIN') ?> <i class="fas fa-caret-left"></i></button>
                                </div>

                            </form>
                            <div class="auth-form-extra-links">
                                <div class="extra-link">
                                    <a href="<?= forgotPasswordLink() ?>"><?php _e('FORGOT_PASSWORD') ?></a>
                                </div>
                                <div class="extra-link">
                                    <a href="<?= registerLink() ?>"><?php _e('REGISTER') ?></a>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </section>
    </div>
</div>