<div id="wrapper">
    <!-- content-->
    <div class="content">

        <?php include 'includes/theme/pages/account/_intro.php' ?>

        <section class="gray-bg main-dashboard-sec" id="sec1">
            <div class="container">

                <div class="col-md-3">
                    <?php include 'includes/theme/pages/account/_menu.php' ?>
                </div>

                <div class="col-md-9">

                    <?php session()->showAlert() ?>

                    <div class="dashboard-title fl-wrap">
                        <h3><?php _e('EDIT_PROFILE') ?></h3>
                    </div>

                    <div class="clearfix"></div>

                    <div class="form-message-placeholder colorful"></div>

                    <div id="form-wrapper">
                        <form id="profile-edit" class="profile-edit custom-form" action="<?= myProfileEditLink() ?>" method="POST">

                            <?= csrf_field() ?>

                            <div class="profile-edit-container fl-wrap block_box">
                                <div class="row">

                                    <div class="col-sm-6 form-group">
                                        <label for="name"><?php _e('FULL_NAME') ?> <i class="fal fa-user"></i></label>
                                        <input type="text" name="name" id="name" class="form-control" value="<?= $loggedUser->NAME ?>">
                                        <p class="help-block"></p>
                                    </div>

                                    <div class="sm-clearfix"></div>

                                    <div class="col-sm-6 form-group">
                                        <label for="website"><?php _e('WEBSITE_LINK') ?> <i class="fal fa-external-link"></i></label>
                                        <input type="text" name="website" id="website" class="form-control foreign" value="<?= $loggedUser->WEBSITE ?>" placeholder="<?= removeEndElement(siteroot(), '/') ?>">
                                        <p class="help-block"></p>
                                    </div>

                                    <div class="sm-clearfix"></div>

                                    <?php if( ! canActivateWithSms() && ! $loggedUser->hasVerifiedMobile() && ! is_mobile($loggedUser->USERNAME) ) : ?>
                                        <div class="col-sm-6 form-group">
                                            <label for="phone"><?php _e('MOBILE_PHONE_NUMBER') ?> <i class="fal fa-phone"></i></label>
                                            <input type="text" name="phone" id="phone" class="form-control" value="<?= $loggedUser->TEL ?>">
                                            <p class="help-block"></p>
                                        </div>

                                        <div class="sm-clearfix"></div>
                                    <?php endif; ?>

                                    <?php if( ! canActivateWithEmail() && ! is_email($loggedUser->EMAIL) && ! is_email($loggedUser->USERNAME) ) : ?>
                                        <div class="col-sm-6 form-group">
                                            <label for="email"><?php _e('EMAIL') ?> <i class="fal fa-envelope"></i></label>
                                            <input type="text" name="email" id="email" class="foreign" value="<?= $loggedUser->EMAIL ?>">
                                            <p class="help-block"><?php _e('ENTER_EMAIL_FOR_FORGOT_PASSWORD') ?></p>
                                        </div>
                                        <div class="sm-clearfix"></div>
                                    <?php endif; ?>

                                    <div class="col-sm-12 form-group">
                                        <label for="credit_card"><?php _e('CREDIT_CARD') ?> <i class="fal fa-credit-card"></i></label>
                                        <input type="text" name="credit_card" id="credit_card" class="form-control" value="<?= $loggedUser->CREDIT_CARD ?>">
                                        <p class="help-block"><?php _e('CREDIT_CARD_DESCRIPTION') ?></p>
                                    </div>

                                    <div class="sm-clearfix"></div>

                                    <div class="col-sm-12 form-group">
                                        <label for="address"><?php _e('ADDRESS') ?> <i class="fal fa-map-marker"></i></label>
                                        <textarea name="address" id="address" class="form-control medium"><?= $loggedUser->ADDRESS ?></textarea>
                                        <p class="help-block"></p>
                                    </div>

                                    <div class="sm-clearfix"></div>

                                    <div class="col-sm-12 form-group">
                                        <label for="biography"><?php _e('BIOGRAPHY') ?> <i class="fal fa-edit"></i></label>
                                        <textarea name="biography" id="biography" class="form-control"><?= safe_text($loggedUser->BIOGRAPHY) ?></textarea>
                                        <p class="help-block"></p>
                                    </div>

                                    <div class="sm-clearfix"></div>

                                </div>
                            </div>


                            <div class="dashboard-title dt-inbox fl-wrap">
                                <h3><?php _e('MY_SOCIALS') ?></h3>
                            </div>

                            <div class="profile-edit-container fl-wrap block_box">
                                <div class="custom-form">
                                    <label for="meta__telegram_id"><?php _e('TELEGRAM_ID') ?> <i class="fa fa-paper-plane"></i></label>
                                    <input type="text" name="meta__telegram_id" id="meta__telegram_id" class="form-control foreign" value="<?= $loggedUser->telegramId() ?>">

                                    <label for="meta__instagram_id"><?php _e('INSTAGRAM_ID') ?> <i class="fab fa-instagram"></i></label>
                                    <input type="text" name="meta__instagram_id" id="meta__instagram_id" class="form-control foreign" value="<?= $loggedUser->instagramId() ?>">

                                    <label for="meta__facebook_id"><?php _e('FACEBOOK_ID') ?> <i class="fab fa-facebook"></i></label>
                                    <input type="text" name="meta__facebook_id" id="meta__facebook_id" class="form-control foreign" value="<?= $loggedUser->facebookId() ?>">

                                    <label for="meta__twitter_id"><?php _e('TWITTER_ID') ?> <i class="fab fa-twitter"></i></label>
                                    <input type="text" name="meta__twitter_id" id="meta__twitter_id" class="form-control foreign" value="<?= $loggedUser->twitterId() ?>">

                                    <button type="submit" class="btn color2-bg float-btn submit-button" data-default-text="<?php _e('SAVE_CHANGES') ?> <i class='fal fa-save'></i>"><?php _e('SAVE_CHANGES') ?> <i class='fal fa-save'></i></button>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </section>

        <div class="limit-box fl-wrap"></div>
    </div>
</div>