<div id="wrapper">

    <div class="content">

        <?php include 'includes/theme/pages/account/_intro.php' ?>

        <section class="gray-bg main-dashboard-sec" id="sec1">
            <div class="container">

                <div class="col-md-3">
                    <?php include 'includes/theme/pages/account/_menu.php' ?>
                </div>

                <div class="col-md-9">

                    <?php session()->showAlert() ?>

                    <div class="dashboard-title fl-wrap">
                        <h3><?php _e('MY_PAYMENTS') ?></h3>
                    </div>

                    <div class="profile-edit-container fl-wrap block_box">
                        <div class="table-responsive-vertical shadow-z-1">
                            <table class="table payment-table m-b-0">
                                <thead>
                                <tr>
                                    <th><?php _e('ORDER_ID') ?></th>
                                    <th><?php echo _e('PRICE', true) . ' (' . trim(setting('CURRENCY')) . ') ' ?></th>
                                    <th><?php _e('PAYMENT_TYPE') ?></th>
                                    <th><?php _e('PAYMENT_DATE') ?></th>
                                    <th><?php _e('PAYMENT__DESCRIPTION') ?></th>
                                    <th><?php _e('STATUS') ?></th>
                                    <th><?php _e('ACTION') ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if (! $payments) {
                                        echo "
                                            <tr>
                                                <td colspan='5'>". _e('NO_RECORD_FOUND', true) ."</td>
                                            </tr>
                                        ";
                                    }
                                    ?>

                                    <?php foreach ($payments as $payment) : ?>
                                        <tr>
                                            <td data-title="<?php _e('ORDER_ID') ?>"><?= $payment->sale_order_id ?></td>
                                            <td data-title="<?= _e('PRICE') ?>"><?= number_format($payment->price) ?></td>
                                            <td data-title="<?= _e('PAYMENT_TYPE') ?>"><?= $payment->paymentKind() ?></td>
                                            <td data-title="<?php _e('PAYMENT_DATE') ?>"><?= $payment->showDate() ?></td>
                                            <td data-title="<?php _e('PAYMENT__DESCRIPTION') ?>"><?= $payment->comment ?></td>
                                            <td data-title="<?php _e('STATUS') ?>"><?= $payment->generalStatus() ?></td>
                                            <td data-title="<?php _e('ACTION') ?>" class="table-actions">
                                                <a href="<?= viewOrderLink($payment->id) ?>" class="green-bg tolt" data-microtip-position="top" data-tooltip="<?php _e('VIEW_PAYMENT') ?>"><i class="fal fa-eye"></i> </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>

                    </div>

                </div>

            </div>
        </section>

        <div class="limit-box fl-wrap"></div>
    </div>

</div>
