<div id="wrapper">

    <div class="content">

        <?php include 'includes/theme/pages/account/_intro.php' ?>

        <section class="gray-bg main-dashboard-sec" id="sec1">
            <div class="container">

                <div class="col-md-3">
                    <?php include 'includes/theme/pages/account/_menu.php' ?>
                </div>

                <div class="col-md-9">

                    <?php session()->showAlert() ?>

                    <div class="dashboard-title fl-wrap">
                        <h3><?= $current_page->TITLE ?></h3>
                    </div>

                    <div class="profile-edit-container fl-wrap block_box">
                        <div class="table-responsive-vertical shadow-z-1">
                            <table class="table payment-table m-b-0">
                                <thead>
                                <tr>
                                    <th><?php _e('TITLE') ?></th>
                                    <th><?php _e('SENDER') ?></th>
                                    <th><?php _e('SEND_DATE') ?></th>
                                    <th><?php _e('ACTION') ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                if (! $messages) {
                                    echo " <tr> <td colspan='5'>". _e('NO_RECORD_FOUND', true) ."</td> </tr> ";
                                }
                                ?>

                                <?php foreach ($messages as $message) : ?>
                                    <tr>
                                        <td data-title="<?php _e('TITLE') ?>"><?= $message->TITLE ?></td>
                                        <td data-title="<?= _e('SENDER') ?>"><?= $message->SENDER_NAME ?></td>
                                        <td data-title="<?= _e('SEND_DATE') ?>"><?= per_date($message->DATE_CREATED, 'Y/m/d') ?></td>
                                        <td data-title="<?php _e('ACTION') ?>" class="table-actions">
                                            <a href="javascript:" data-click-loads-message data-message="<?= $message->MESSAGE_ID ?>" class="green-bg tolt medium" data-microtip-position="top" data-tooltip="<?php _e('VIEW') ?>"><i class="fal fa-eye"></i></a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>

                    </div>

                </div>

            </div>
        </section>

        <div class="limit-box fl-wrap"></div>
    </div>

</div>

<div class="remodal messages-modal" id="message-modal" data-remodal-id="messageModal">
    <button data-remodal-action="close" class="remodal-close"></button>
    <div class="modal-body">

    </div>
</div>
