<div id="wrapper">

    <div class="content">

        <?php include 'includes/theme/pages/account/_intro.php' ?>

        <section class="gray-bg main-dashboard-sec" id="sec1">
            <div class="container">

                <div class="col-md-3">
                    <?php include 'includes/theme/pages/account/_menu.php' ?>
                </div>

                <div class="col-md-9">

                    <?php session()->showAlert() ?>

                    <div class="dashboard-title fl-wrap">
                        <h3><?php _e('MY_ITEMS') ?></h3>
                    </div>

                    <div class="dashboard-list-box fl-wrap">

                        <?php
                        foreach ($resource_items as $ads) :
                            if($ads->is_expired()) {
                                $default_expired_plan = $ads;
                                if($ads->is_free()) {
                                    $default_expired_plan = ads()->select_strongest_plan();
                                }
                            }

                            ?>
                            <div class="dashboard-list fl-wrap">
                                <div class="dashboard-message">
                                    <div class="booking-list-contr">

                                        <?php if ( $ads->is_rejected() ) : ?>
                                            <a data-remodal-target="rejection_modal_<?= $ads->ADS_ID ?>" class="yellow-bg tolt medium" data-microtip-position="top" data-tooltip="<?php _e('REJECTION_CAUSE') ?>"><i class="fal fa-info"></i></a>
                                        <?php endif; ?>

                                        <?php if( ! $ads->is_expired() ) : ?>
                                            <a href="<?= $ads->editLink() ?>" class="color-bg tolt" data-microtip-position="top" data-tooltip="<?php _e('EDIT') ?>"><i class="fal fa-edit"></i></a>
                                        <?php endif; ?>

                                        <?php if( $ads->isPendingPayment() ) : ?>
                                            <a href="<?= $ads->paymentLink() ?>" class="purp-bg tolt" data-microtip-position="top" data-tooltip="<?php _e('PAY') ?>"><i class="fal fa-sack-dollar"></i></a>
                                        <?php endif; ?>

                                        <?php if( $ads->is_shown() ) : ?>
                                            <a data-remodal-target="mutation_modal_<?= $ads->ADS_ID ?>" class="color2-bg tolt" data-microtip-position="top" data-tooltip="<?php _e('MUTATION') ?>"><i class="fal fa-sync-alt"></i></a>
                                        <?php endif; ?>

                                        <?php if( ! $ads->is_free() && ! $ads->is_expired() ): ?>
                                            <a data-remodal-target="extension_modal_<?= $ads->ADS_ID ?>" class="yellow-bg tolt" data-microtip-position="top" data-tooltip="<?php _e('EXTEND') ?>"><i class="fal fa-alarm-clock"></i></a>
                                        <?php endif; ?>

                                        <?php if( $ads->is_expired() ): ?>
                                            <a data-remodal-target="expired_extension_modal_<?= $ads->ADS_ID ?>" class="yellow-bg tolt" data-microtip-position="top" data-tooltip="<?php _e('EXTEND') ?>"><i class="fal fa-alarm-clock"></i></a>
                                        <?php endif; ?>

                                        <?php if( ! $ads->is_expired() ) : ?>
                                            <a data-remodal-target="change_plan_<?= $ads->ADS_ID ?>" class="green-bg tolt medium" data-microtip-position="top" data-tooltip="<?= ($ads->is_free()) ? _e('PROMOTE') : _e('CHANGE_PLAN') ?>"><i class="fal fa-sort-amount-up"></i></a>
                                        <?php endif; ?>

                                        <form method="POST" class="should-confirm inline-form" action="<?= $ads->deleteLink() ?>">
                                            <?= csrf_field() ?>
                                            <button type="submit" class="red-bg tolt" data-microtip-position="top" data-tooltip="<?php _e('DELETE') ?>"><i class="fal fa-trash-alt"></i></button>
                                        </form>
                                    </div>

                                    <div class="dashboard-message-text">
                                        <img src="<?= $ads->featuredImage('thumb') ?>" alt="<?= safe($ads->ADS_TITLE); ?>">
                                        <h4><a href="<?= $ads->viewLink() ?>"><?= safe($ads->ADS_TITLE); ?></a></h4>
                                        <div class="geodir-category-location clearfix"><?= $ads->categoryTree() ?></div>
                                    </div>

                                    <div class='dashboard-text-footer level'>
                                        <div class='listing-rating'><?= $ads->starRate() ?></div>
                                        <div class="item-status"><?= $ads->ads_general_status() ?></div>
                                    </div>
                                </div>
                            </div>

                            <!-------------------------------------
                                Extension Modal For Usual Items
                            ---------------------------------------->
                            <?php if( ! $ads->is_free() && ! $ads->is_expired() ): ?>
                            <div class="remodal extension-modal" data-remodal-id="extension_modal_<?= $ads->ADS_ID ?>">
                                <button data-remodal-action="close" class="remodal-close"></button>

                                <form action="<?= $ads->extendItemLink() ?>" class="darker-form">

                                    <div class="modal-body clearfix">
                                        <p> <?php _e('ADS_TITLE') ?> : </p> <h4> <?= $ads->ADS_TITLE ?> </h4>
                                        <p> <?php _e('ADS_PLAN') ?> : </p> <h4><?= $ads->PLAN_TITLE ?></h4>

                                        <h2> <?php _e('CHOOSE_EXTENSION_PERIOD'); ?> : </h2>

                                        <div class="form-group btn-group--float btn-group-divided btn-group-list text-right">
                                            <div class="btn-group" data-toggle="buttons">
                                                <?php
                                                foreach($periods_discount as $period => $discount)
                                                {
                                                    $discount_text = ($period == 1) ? '' : ' + ' . $discount . '% ' . _e('JUST_DISCOUNT', true);
                                                    ?>
                                                    <label class='btn <?= activeState($period, 1, 'active') ?>'>
                                                        <input type='radio' name='period' value='<?= $period ?>' <?= activeState($period, 1, 'check') ?>> <?= $period ?> <?php _e('PERIOD') ?> (<?= $ads->PLAN_DAYS * $period . _e('DAY', true) ?>) <?= $discount_text ?> <br/><small><?php showPrice($ads->discount($period, $discount)) ?> </small>
                                                    </label>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="modal-footer">
                                        <button data-remodal-action="cancel" class="remodal-cancel"> <?php _e('CANCEL') ?> </button>
                                        <button type="submit" class="remodal-confirm"> <?php _e('EXTENSION') ?> </button>
                                    </div>
                                    <br>
                                </form>
                            </div>
                        <?php endif; ?>

                            <!-------------------------------------
                                Extension Modal For Expired Items
                            ---------------------------------------->
                            <?php  if ($ads->is_expired()) : ?>
                            <div class="remodal extension-modal" data-remodal-id="expired_extension_modal_<?= $ads->ADS_ID ?>">
                                <button data-remodal-action="close" class="remodal-close"></button>
                                <form action="<?= $ads->extendItemLink() ?>" class="darker-form">

                                    <div class="modal-body">
                                        <p> <?php _e('ADS_TITLE') ?> : </p>
                                        <h4> <?= $ads->ADS_TITLE ?> </h4>
                                        <p> <?php _e('ADS_PLAN') ?> : </p>

                                        <div class="form-group select-group--float form-group--float form-group--icon " >
                                            <select name="plan" id="plan" class="form-control select-plan-for-extension" data-item-id="<?= $ads->ADS_ID ?>" title="plan">
                                                <?php
                                                /** @var App\Plan $plan */
                                                foreach ($plans as $plan) {
                                                    if($plan->isFree()) {
                                                        continue;
                                                    }

                                                    echo "<option value='" . $plan->ID . "' selected >" . $plan->PLAN_TITLE . " (" . showPrice($plan->PLAN_PRICE, true) . ")</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <br>

                                        <h2> <?php _e('CHOOSE_EXTENSION_PERIOD'); ?> : </h2>

                                        <div class="form-group btn-group--float btn-group-divided btn-group-list text-right pr-0 clearfix">
                                            <div class="btn-group" data-toggle="buttons" id="extension-plans-wrappers-<?= $ads->ADS_ID ?>">
                                                <?php
                                                foreach($periods_discount as $period => $discount)
                                                {
                                                    $discount_text = ($period == 1) ? '' : ' + ' . $discount . '% ' . _e('JUST_DISCOUNT', true);
                                                    ?>
                                                    <label class='btn <?= activeState($period, 1, 'active') ?>'>
                                                        <input type='radio' name='period' value='<?= $period ?>' <?= activeState($period, 1, 'check') ?>/> <?= $period ?> <?php _e('PERIOD') ?> (<?= $default_expired_plan->PLAN_DAYS * $period . _e('DAY', true) ?>) <?= $discount_text ?> <br/><small><?php showPrice($default_expired_plan->discount($period, $discount)) ?> </small>
                                                    </label>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button data-remodal-action="cancel" class="remodal-cancel"> <?php _e('CANCEL') ?> </button>
                                        <button type="submit" class="remodal-confirm"> <?php _e('EXTENSION') ?> </button>
                                    </div>
                                    <br>
                                </form>
                            </div>
                        <?php endif; ?>

                            <!-------------------------------------
                                        Mutation Modal
                            ---------------------------------------->
                            <?php if($ads->is_shown()) : ?>
                            <div class="remodal extension-modal" data-remodal-id="mutation_modal_<?= $ads->ADS_ID ?>">
                                <button data-remodal-action="close" class="remodal-close"></button>
                                <?php
                                $updateLeft = $ads->updateCountLeft();
                                if( ! empty($updateLeft) ) :
                                    ?>
                                    <form method="POST" action="<?= $ads->mutateItemLink() ?>" class="darker-form">

                                        <?= csrf_field() ?>

                                        <div class="modal-body">
                                            <p> <?php _e('ADS_TITLE') ?> : </p>
                                            <h4> <?= $ads->ADS_TITLE ?> </h4>
                                            <p> <?php _e('REMAINING_MUTATION') ?> : </p>
                                            <h4><?= $updateLeft ?></h4>
                                            <p class="modal-description"> <?php _e('MUTATE_DESCRIPTION') ?> </p>
                                        </div>
                                        <div class="modal-footer">
                                            <button data-remodal-action="cancel" class="remodal-cancel"> <?php _e('CANCEL') ?> </button>
                                            <button type="submit" class="remodal-confirm"><?php _e('DO_MUTATE') ?></button>
                                        </div>
                                        <br>

                                    </form>
                                <?php else : ?>
                                    <div class="modal-body">
                                        <h3> <?php _e('NO_MUTATION_LEFT') ?> </h3>
                                        <br>
                                        <h6> <?php _e('NO_MUTATION_LEFT_DESCRIPTION') ?> </h6>
                                    </div>
                                    <div class="modal-footer">
                                        <button data-remodal-action="cancel" class="remodal-cancel"> <?php _e('CANCEL') ?> </button>
                                    </div>
                                    <br>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>

                            <!-------------------------------------
                                    Rejection Cause Modal
                            ---------------------------------------->
                            <?php if ($ads->is_rejected()) : ?>
                            <div class="remodal extension-modal" data-remodal-id="rejection_modal_<?= $ads->ADS_ID ?>">
                                <button data-remodal-action="close" class="remodal-close"></button>
                                <div class="modal-body">
                                    <h5> <?php _e('REJECTION_CAUSE_TITLE') ?> </h5><br>
                                    <div class="text-right"><?= $ads->REJECTION_CAUSE ?></div><br>
                                    <h6 class="description"><?php _e('REJECTION_CAUSE_EDIT') ?></h6>
                                </div>
                                <div class="modal-footer">
                                    <button data-remodal-action="cancel" class="remodal-cancel"><?php _e('CLOSE') ?></button>
                                </div>
                                <br>
                            </div>
                        <?php endif; ?>

                            <!-------------------------------------
                                        Change Plan Modal
                            ---------------------------------------->
                            <div class="remodal extension-modal" data-remodal-id="change_plan_<?= $ads->ADS_ID ?>">
                                <button data-remodal-action="close" class="remodal-close"></button>
                                <form action="<?= $ads->changePlanLink() ?>" class="darker-form">

                                    <div class="modal-body">
                                        <p> <?php _e('ADS_TITLE') ?> : </p>
                                        <h4> <?= $ads->ADS_TITLE ?> </h4>
                                        <p> <?php _e('ADS_PLAN') ?> : </p>
                                        <h4> <?php echo $ads->PLAN_TITLE ?> </h4>
                                        <h2> <?php _e('CHOOSE_ADS_PLAN'); ?> : </h2>

                                        <div class="form-group select-group--float form-group--float form-group--icon">
                                            <select name="plan" class="form-control advanced-select" title="plan">
                                                <?php
                                                foreach ($plans as $plan) {
                                                    if($plan->ID == $ads->PLAN_ID || $plan->isFree()) {
                                                        continue;
                                                    }

                                                    echo "<option value='" . $plan->ID . "' selected >" . $plan->PLAN_TITLE . " (" . showPrice($plan->PLAN_PRICE, true) . ")</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>

                                        <a href="<?php echo siteroot() ?>pricing" class="see-features" target="_blank"><?php _e('SEE_SPECIAL_PLANS') ?></a>

                                    </div>
                                    <div class="modal-footer">
                                        <button data-remodal-action="cancel" class="remodal-cancel"> <?php _e('CANCEL') ?> </button>
                                        <button type="submit" class="remodal-confirm"> <?php _e('CHANGE_PLAN') ?> </button>
                                    </div>
                                    <br>
                                </form>
                            </div>

                        <?php endforeach; ?>

                        <?php include('includes/core/components/_pagination.php'); ?>

                    </div>

                </div>

            </div>
        </section>

        <div class="limit-box fl-wrap"></div>
    </div>

</div>
