<div class="col-sm-12 form-div p-0">
    <div class="form-group form-group--float form-group--icon">
        <input type="text" id="frm_title" name="frm_title" class="form-control" value="<?= $ads->ADS_TITLE ?>">
        <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
        <label for="frm_title"><?php _e('ADS_TITLE') ?></label>
        <p class="help-block"></p>
    </div>
</div>
<div class="col-sm-6 col-xs-12 form-div pr-0 sm-p0" id="category-dynamic-select">
    <div class="form-group select-group--float form-group--float form-group--icon select-group--dynamic" id="category-form-group">
        <div class="dynamic-select" data-default-text="<?php _e('ALL_CATEGORIES') ?>">
            <?= ($has_category_filter) ?: _e('CHOOSE', true) ?>
        </div>
        <span class="input-icon-addon top-3"> <i class="fa fa-sitemap"></i> </span>
        <span class="remove-selected-item" style="<?= ($has_category_filter) ? 'display: block' : 'display: none' ?>"> <i class="fa fa-times"></i> </span>
        <label><?php _e('ADS_CATEGORY') ?></label>
        <p class="help-block" id="category-help-block"></p>
    </div>

    <div class="dynamic-select-dropdown">
        <div class="dropdown-header">
            <i class="fa fa-times close-dropdown"></i>
        </div>
        <div class="dropdown-body">
            <ul class="dropdown-list no-list-style">
                <?php
                foreach ($categories as $category) {
                    echo "<li class='dropdown-list-item' data-category='{$category->ID}'>{$category->logoMarkup('dynamic-select-icon')}{$category->CATEGORY_NAME}</li>";
                }
                ?>
            </ul>
            <div class="dropdown-inputs">
                <input type="hidden" name="category" id="category_input" value="<?= optional($current_category)->id() ?>">
                <input type="hidden" name="subcategory" id="subcategory_input" value="<?= optional($current_subcategory)->id() ?>">
                <input type="hidden" name="subsidiary" id="subsidiary_input" value="<?= optional($current_subsidiary)->id() ?>">
            </div>

            <div class="dropdown-template" style="display: none">
                <?php
                foreach ($categories as $category) {
                    echo "<li class='dropdown-list-item' data-category='{$category->ID}'>{$category->logoMarkup('dynamic-select-icon')}{$category->CATEGORY_NAME}</li>";
                }
                ?>
            </div>
        </div>

    </div>
</div>

<div class="col-sm-6 col-xs-12 form-div pr-0 placeholder-col">

</div>

<div id="custom-fields-wrapper">
    <div class="row custom-fields-placeholder">
        <?php
        if (! empty($custom_fields)) {
            foreach ($custom_fields as $custom_field) {
                $custom_field->show('edit-modern');
            }
        }
        ?>
    </div>
</div>

<div class="hide-when-custom-has-fields" style="<?= ($custom_fields) ? 'display:none' : false; ?>">
    <div class="col-sm-6 col-xs-12 form-div pr-0 sm-p0">
        <div class="form-group form-group--float form-group--icon has-checkbox-addon <?= groupActiveState($ads->ADS_PRICE) ?>">
            <input type="text" id="frm_price" name="frm_price" class="form-control ltr digits-field" value="<?= $ads->ADS_PRICE ?>">
            <span class="input-icon-addon"><i class="fa fa-sack-dollar"></i> </span>
            <label for="frm_price"> &nbsp;<?= _e('PRICE', true) . ' (' . setting('CURRENCY_EXHIBITIVE') . ')' ?></label>
            <div class='digits-divider'></div>
        </div>
        <div class="checkbox-addon">
            <div class="filter-tags">
                <input type="checkbox" data-text-with-checkbox data-input="#frm_price" name="frm_price_deal" id="frm_price_deal">
                <label for="frm_price_deal"> <?= _e('DEAL') ?> </label>
            </div>
        </div>
    </div>

    <?php if (setting('SUBMIT__ENABLE_DISCOUNT_FIELD') === 'YES') : ?>
        <div class="col-sm-6 col-xs-12 form-div p-0 <?= groupActiveState($ads->ADS_DISCOUNT) ?>">
            <div class="form-group form-group--float form-group--icon">
                <input type="text" id="frm_discount" name="frm_discount" class="form-control digits-field ltr" value="<?= $ads->ADS_DISCOUNT ?>">
                <span class="input-icon-addon top-3"> <i class="fa fa-handshake"></i> </span>
                <label for="frm_discount"> &nbsp; <?php _e('DISCOUNT') ?> </label>
            </div>
        </div>
    <?php endif; ?>
</div>

<div class="col-xs-12 form-div p-0">
    <div class="form-group form-group--float form-group--icon">
        <textarea name="frm_description" id="frm_description" class="form-control medium"><?= strip_tags($ads->ADS_DESCRIPTION) ?></textarea>
        <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
        <label for="frm_description"><?php _e('ADS_DESCRIPTION') ?></label>
        <p class="help-block"></p>
    </div>
</div>
<div class="clearfix"></div>
<div class="col-md-6 col-sm-12 form-div pr-0 sm-p0" id="location-dynamic-select">
    <div class="form-group form-group--float form-group--icon form-group--active select-group--dynamic"  id="location-form-group">
        <div class="dynamic-select" data-default-text="<?php _e('ALL_LOCATIONS') ?>">
            <?= ($has_location_filter) ?: _e('ALL_LOCATIONS', true) ?>
        </div>
        <span class="input-icon-addon top-3"> <i class="fa fa-location"></i> </span>
        <span class="remove-selected-item"  style="<?= ($has_location_filter) ? 'display: block' : 'display: none' ?>"> <i class="fa fa-times"></i> </span>
        <label><?php _e('LOCATION') ?></label>
        <p class="help-block" id="location-help-block"></p>
    </div>

    <div class="dynamic-select-dropdown">
        <div class="dropdown-header">
            <i class="fa fa-times close-dropdown"></i>

            <div class="dropdown-search">
                <div class="form-group form-group--float form-group--icon form-group--active">
                    <input type="text" id="location_search" name="location_search" class="form-control dropdown-search-input">
                    <span class="input-icon-addon top-3"> <i class="fa fa-search"></i> </span>
                    <label for="location_search"><?php _e('SEARCH_IN_LIST') ?></label>
                    <p class="help-block"></p>
                </div>
            </div>
        </div>
        <div class="dropdown-body">
            <ul class="dropdown-list no-list-style">
                <?php
                $states_list_output = "";
                foreach ($states as $location) {
                    $states_list_output .= "<li class='dropdown-list-item' data-state='{$location->id()}' data-latitude='{$state->latitude}' data-longitude='{$state->longitude}'>{$location->name()}</li>";
                }

                echo $states_list_output;
                ?>
            </ul>
            <div class="dropdown-inputs">
                <input type="hidden" name="state" id="state_input" value="<?= optional($current_state)->id() ?>">
                <input type="hidden" name="city" id="city_input" value="<?= optional($current_city)->id() ?>">
            </div>

            <div class="dropdown-template" style="display: none">
                <?= $states_list_output ?>
            </div>
        </div>

    </div>
</div>

<div class="col-md-6 col-sm-12 form-div p-0" id="link-placeholder" style="<?= ($current_plan->has_link()) ? false : 'display:none' ?>">
    <div class="form-group form-group--float form-group--icon">
        <input type="text" id="frm_link" name="frm_link" class="form-control ltr" value="<?= $ads->ADS_LINK ?>">
        <span class="input-icon-addon top-3"> <i class="fa fa-external-link"></i> </span>
        <label for="frm_link"><?php _e('LINK') ?></label>
    </div>
</div>

<?php if (!registerNeedsActivation() || !canActivateWithSMS()) : ?>
    <div class="col-sm-6 col-xs-12 form-div pr-0 sm-p0">
        <div class="form-group form-group--float form-group--icon">
            <input type="text" id="frm_tel" name="frm_tel" class="form-control ltr" value="<?= $ads->ADS_OWNER_PHONE ?>">
            <span class="input-icon-addon top-3"> <i class="fa fa-phone"></i> </span>
            <label for="frm_tel"><?php _e('ADS_OWNER_PHONE') ?></label>
        </div>
    </div>
<?php endif; ?>

<?php if (!registerNeedsActivation() || !canActivateWithEmail()) : ?>
    <div class="col-sm-6 col-xs-12 form-div p-0 sm-p0">
        <div class="form-group form-group--float form-group--icon">
            <input type="text" id="frm_email" name="frm_email" class="form-control ltr" value="<?= $ads->ADS_OWNER_EMAIL ?>">
            <span class="input-icon-addon top-3"> <i class="fa fa-envelope"></i> </span>
            <label for="frm_email"><?php _e('ADS_OWNER_EMAIL') ?></label>
        </div>
    </div>
<?php endif; ?>

<?php if (setting('SUBMIT__ENABLE_FULL_ADDRESS_FIELD') === 'YES') : ?>
    <div class="col-xs-12 form-div p-0">
        <div class="form-group form-group--float form-group--icon">
            <textarea name="frm_address" id="frm_address" class="form-control small"><?= $ads->ADS_OWNER_ADDRESS ?></textarea>
            <span class="input-icon-addon top-3"> <i class="fa fa-map-signs"></i> </span>
            <label for="frm_address"><?php _e('ADS_ADDRESS') ?></label>
        </div>
    </div>
<?php endif; ?>

<div class="col-sm-12 col-xs-12 form-div p-0">
    <div class="form-group select-group--float form-group--float form-group--icon">
        <label for="frm_keywords"><?php _e('TAGS') ?></label>
        <select class="form-control advanced-select-tags" name="frm_keywords[]" id="frm_keywords" multiple="multiple">
            <?php
            foreach ($tags as $tag) {
                echo "<option selected>{$tag->TAG_NAME}</option>";
            }
            ?>
        </select>
        <div id="tags-input-help" class="input-sticky-help tags-help tolt big" data-microtip-position="top" data-tooltip="<?php _e('POPUP_ADS_TAGS_HELP_TITLE', false, array('{%1%}' => $current_plan->MAX_KEYWORD_COUNT)) ?>"><i class='fa fa-question-circle'></i></div>
    </div>
</div>
