<div id="wrapper">

    <div class="content">

        <?php include 'includes/theme/pages/account/_intro.php' ?>

        <section class="gray-bg main-dashboard-sec" id="sec1">
            <div class="container">
                <div class="col-md-12">
                    <div class="fl-wrap block_box p-20">
                        <div class="submit-item__success p-b-0 text-center">
                            <i class="fa fa-star zoomIn"></i>
                            <h2><?php _e('CHANGE_PLAN_BILL') ?></h2>
                            <div class="next-line"></div>
                        </div>

                        <div class="card__body p-t-0 p-b-0">
                            <div class="table-responsive-vertical shadow-z-1">
                                <table class="table payment-table m-b-0">
                                    <thead>
                                    <tr>
                                        <th><?php _e('ADS_TITLE') ?></th>
                                        <th><?php _e('CATEGORY') ?></th>
                                        <th><?php _e('ADS_PLAN') ?></th>
                                        <th><?php _e('JUST_DISCOUNT') ?></th>
                                        <th><?php _e('FINAL_PRICE') ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td data-title="<?php _e('ADS_TITLE') ?>"><?= $ads->ADS_TITLE ?></td>
                                        <td data-title="<?php _e('CATEGORY') ?>"><?= $ads->categoryTree() ?></td>
                                        <td data-title="<?php _e('ADS_PLAN') ?>">
                                            <a class="link" href="<?= priceListLink() ?>" target="_blank"><?= $new_plan->PLAN_TITLE ?></a>
                                            <?php if (!$new_plan->is_text()) : ?>
                                                <br>
                                                <small class='listing-rating white'><?= $new_plan->starRate() ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td data-title="<?php _e('JUST_DISCOUNT') ?>" id="discount-cell">

                                            <span id="initial-discount"> --- <br></span>

                                            <a class="link" data-i-have-coupon href="javascript:void(0);"><?php _e('HAVE_COUPON') ?></a>

                                            <form method="post" id="coupon_input_form" style="display: none">
                                                <div class="form-group">
                                                    <input type="text" class="form-control" name="coupon_code" id="coupon_code" placeholder="<?php _e('ENTER_COUPON') ?>" style="width: 200px; margin: 0 auto; display: inline-block">
                                                    <button type="submit" class="btn color2-bg btn-small no-shadow"><?php _e('APPLY') ?></button>
                                                </div>
                                            </form>

                                        </td>
                                        <td data-title="<?php _e('FINAL_PRICE') ?>"><span id="initial-price" data-value="<?= $new_plan->finalPrice() ?>"><?= price_format($new_plan->finalPrice()) ?></span> <br><span id="final-price"></span></td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="pt-0">
                            <?php
                            $show_bank_fish = false;
                            $ads_id = $ads->ADS_ID;
                            include('includes/theme/partials/_choose_gateway.php');
                            ?>
                        </div>


                    </div>
                </div>
            </div>
        </section>

    </div>
</div>