<div id="wrapper">

    <div class="content">

        <?php include 'includes/theme/pages/account/_intro.php' ?>

        <section class="gray-bg main-dashboard-sec" id="sec1">
            <div class="container">

                <div class="col-md-3">
                    <?php include 'includes/theme/pages/account/_menu.php' ?>
                </div>

                <div class="col-md-9">

                    <?php session()->showAlert() ?>

                    <div class="dashboard-title fl-wrap">
                        <h3><?php _e('MY_COMMENTS') ?></h3>
                    </div>

                    <div class="profile-edit-container fl-wrap block_box">

                        <?php foreach ($resource_items as $comment) : ?>
                            <div class="reviews-comments-item">
                                <div class="review-comments-avatar">
                                    <img src="<?= user_logo($comment->USER_ID) ?>" alt="avatar">
                                </div>
                                <div class="reviews-comments-item-text fl-wrap">
                                    <div class="reviews-comments-header fl-wrap">
                                        <h4><a href="<?= $comment->user()->profileLink() ?>"><?= $comment->user()->publicName(false) ?></a> در  <a href="<?= optional($comment->ads())->viewLink() ?>" target="_blank"><?= optional($comment->ads())->ADS_TITLE ?></a></h4>
                                        <div class="review-score-user">
                                            <div class="reviews-comments-item-date"><span><i class="far fa-calendar-check"></i><?= per_date($comment->created_at, 'j F Y') ?></span></div>
                                        </div>
                                    </div>
                                    <p class="gray"><?= safe($comment->text) ?></p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <?php include 'includes/core/components/_pagination.php' ?>

                </div>

            </div>
        </section>

        <div class="limit-box fl-wrap"></div>
    </div>

</div>
