<div id="wrapper">

    <div class="content">

        <?php include 'includes/theme/pages/account/_intro.php' ?>

        <section class="gray-bg main-dashboard-sec" id="sec1">
            <div class="container">

                <div class="col-md-3">
                    <?php include 'includes/theme/pages/account/_menu.php' ?>

                    <?php include 'includes/theme/pages/account/affiliate/_history_summery.php' ?>

                </div>

                <div class="col-md-9">

                    <?php session()->showAlert() ?>

                    <div class="dashboard-title fl-wrap level">
                        <h3><?php _e('MY_EARNINGS') ?></h3>
                        <a href="<?= affiliateHistoryLink() ?>?action=withdrawal" class="btn color2-bg float-btn submit-button"><?php _e('WITHDRAWAL_REQUEST') ?> <i class="fal fa-sack-dollar"></i></a>
                    </div>

                    <div class="profile-edit-container fl-wrap block_box">
                        <div class="table-responsive-vertical shadow-z-1">
                            <table class="table payment-table m-b-0">
                                <thead>
                                <tr>
                                    <th><?php _e('ADS/PLAN') ?></th>
                                    <th><?php echo _e('PRICE', true) . ' (' . setting('CURRENCY_EXHIBITIVE') . ') ' ?></th>
                                    <th><?php echo _e('COMMISION', true) . ' (' . setting('CURRENCY_EXHIBITIVE') . ') ' ?></th>
                                    <th><?php _e('CREATED_DATE') ?></th>
                                    <th><?php _e('STATUS') ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                if (! $affiliates) {
                                    echo "
                                            <tr>
                                                <td colspan='5'>". _e('NO_RECORD_FOUND', true) ."</td>
                                            </tr>
                                        ";
                                }
                                ?>

                                <?php
                                /** @var App\Affiliate $affiliate */
                                foreach ($affiliates as $affiliate) :
                                ?>
                                    <tr>
                                        <td data-title="<?php _e('ADS/PLAN') ?>"><?= $affiliate->comment ?></td>
                                        <td data-title="<?= _e('PRICE') ?>"><?= number_format($affiliate->price) ?></td>
                                        <td data-title="<?= _e('COMMISION') ?>"><?= number_format($affiliate->commision) ?></td>
                                        <td data-title="<?php _e('CREATED_DATE') ?>"><?= $affiliate->showDate() ?></td>
                                        <td data-title="<?php _e('STATUS') ?>"><?= $affiliate->showStatus() ?></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>

                    </div>

                </div>

            </div>
        </section>

        <div class="limit-box fl-wrap"></div>
    </div>

</div>
