<?php if (hasApplication()) : ?>
    <div class="row download-application">
        <div class="col-sm-2 col-xs-12 application-icon">
            <img src="images/logo.png" alt="logo">
        </div>
        <div class="col-sm-6 col-xs-12 application-text">
            <p class="application-title">
                <?php
                if ($isAndroid) {
                    echo _e('ANDROID_APP', true, ['{%1%}' => setting('SITE_TITLE')]);
                }
                if ($isIos) {
                    echo _e('IOS_APP', true, ['{%1%}' => setting('SITE_TITLE')]);
                }
                ?>
            </p>
            <p class="application-subtitle"> <?= setting('SITE_SUBTITLE') ?> </p>
        </div>

        <div class="col-sm-4 col-xs-12 application-button ">
            <a class="btn color2-bg" href="<?= $isAndroid ? androidDownloadLink() : setting('IOS_APK_URL') ?>" download>
                <i class="fa fa-download"></i> <?php _e('DOWNLOAD') ?>
            </a>
        </div>
    </div>
<?php endif; ?>
