<?php

use App\Ads;

/**
 * @param App\Page|null $page
 * @param null $classes
 * @return string
 */
function body_class($page = null, $classes = null) {
    if ($page) {
        $classes = $page->getOptions()->body_classes;
    }

    return ($classes) ?: 'front-page';
}

/**
 * @param App\Page|null $page
 * @param null $classes
 * @return string
 */
function header_class($page = null, $classes = null) {
    if ($page) {
        $classes = $page->getOptions()->header_classes;
    }

    return ($classes) ?: '';
}

/**
 * renders breadcrumb
 *
 * @param array $breadcrumbs_items
 * @param bool $show_main_page
 */
function breadcrumbs(array $breadcrumbs_items, $show_main_page = true) {

    if ($show_main_page) {
        echo "<a href='". siteroot() ."'><i class='far fa-home breadcrumb-home'></i></a>";
    }

    foreach ($breadcrumbs_items as $path_title => $path_link) {
        if (! empty($path_link)) {
            echo "<a href='{$path_link}'>{$path_title}</a>";
        } else {
            echo "<span>{$path_title}</span>";
        }
    }
}

/**
 * returns html presentation of Prices for items
 *
 * @param $price
 * @param null $title
 * @return string
 */
function showAdsPrice($price, $title = null) {
    $title = ($title) ?: _e('PRICE', true);

    if (is_numeric($price)) {
        return "<div class='item-price'>
                    {$title}: <span class='price'>". number_format($price) ."</span> ". setting('CURRENCY_EXHIBITIVE') ."
                </div>";
    }

    return "<div class='item-price'>
                {$title}: <span class='price'>{$price}</span>
            </div>";
}

/**
 * Show Ads item in list
 *
 * @param $ads
 * @param string $image_type
 * @param int $ads_per_row
 */
function showAds(Ads $ads, $image_type = 'thumb', $ads_per_row = 4) {

    $ads->checkStatus();

    $title = safe($ads->ADS_TITLE);

    if (setting('ADS_LIST__SHOW_PRICE') === 'YES') {
        $footer_output = $ads->showAdsPrice();
    } else {
        $footer_output = "<div class='item-category'>{$ads->categoryTree()}</div>";
    }

    $ribbon_output = ($ads->hasRibbon()) ? "<div class='item-ribbon'><span>{$ads->RIBBON_TEXT}</span></div>" : null;
    $ads_date_output = (setting('SHOW_CREATED_TIME_ON_ADS') === "YES") ? "<div class='listing-date'> ". elapsedTime($ads->FROM_UPDATED_DATE) ." </div>" : null;

    echo "
        <div class='listing-item'>
            {$ribbon_output}
            <article class='geodir-category-listing fl-wrap'>
                <div class='geodir-category-img'>
                    <a href='{$ads->viewLink()}' title='{$title}' class='geodir-category-img-wrap fl-wrap'>
                        <img loading='lazy' src='{$ads->featuredImage($image_type)}' alt='{$title}'>
                    </a>
                    <div class='geodir-category-opt'>
                        <div class='listing-rating'>{$ads->starRate(false)}</div>
                        {$ads_date_output}
                    </div>
                </div>
                <div class='geodir-category-content fl-wrap title-sin_item'>
                    <div class='geodir-category-content-title fl-wrap'>
                        <div class='geodir-category-content-title-item'>
                            <h2><a href='{$ads->viewLink()}'>{$title}</a></h2>
                        </div>
                    </div>
                    
                    <div class='geodir-category-footer fl-wrap'>
                        <div class='item-info-wrapper'>
                            {$footer_output}
                        </div>
                        <div class='geodir-category-location fl-wrap'>{$ads->location()}</div>
                    </div>
                </div>
            </article>
        </div>
    ";
}


/**
 * Returns the icon class for title field based on the type of activation
 *
 * @return String
 */
function usernameIcon()
{
    if (usernameType() === 'email') {
        return 'fa fa-envelope';
    }
    if (usernameType() === 'mobile') {
        return 'fa fa-phone';
    }
    if (usernameType() === 'all') {
        return 'fa fa-user';
    }

    return null;
}

/**
 * Returns html output for social networks
 *
 * @return string
 */
function socialNetworks()
{
    $socials = "";

    if (not_empty(setting('FACEBOOK_URL'))) {
        $socials .= "<li><a title='Facebook' href='" . setting('FACEBOOK_URL') . "' target='_blank'><i class='fab fa-facebook-f'></i></a></li>";
    }
    if (not_empty(setting('TWITTER_URL'))) {
        $socials .= "<li><a title='Twitter' href='" . setting('TWITTER_URL') . "' target='_blank'><i class='fab fa-twitter'></i></a></li>";
    }
    if (not_empty(setting('GOOGLEPLUS_URL'))) {
        $socials .= "<li><a title='GooglePlus' href='" . setting('GOOGLEPLUS_URL') . "' target='_blank'><i class='fab fa-google-plus'></i></a></li>";
    }
    if (not_empty(setting('INSTAGRAM_URL'))) {
        $socials .= "<li><a title='Instagram' href='" . setting('INSTAGRAM_URL') . "' target='_blank'><i class='fab fa-instagram'></i></a></li>";
    }
    if (not_empty(setting('LINKEDIN_URL'))) {
        $socials .= "<li><a title='LinkedIn' href='" . setting('LINKEDIN_URL') . "' target='_blank'><i class='fab fa-linkedin'></i></a></li>";
    }
    if (not_empty(setting('PINTEREST_URL'))) {
        $socials .= "<li><a title='Pinterest' href='" . setting('PINTEREST_URL') . "' target='_blank'><i class='fab fa-pinterest'></i></a></li>";
    }
    if (not_empty(setting('TELEGRAM_URL'))) {
        $socials .= "<li><a title='Telegram' href='" . setting('TELEGRAM_URL') . "' target='_blank'><i class='fa fa-paper-plane'></i></a></li>";
    }

    $socials .= "<li><a title='RSS خوراک ' href='" . rssLink() . "' target='_blank'><i class='fa fa-rss'></i></a></li>";

    return $socials;
}

/**
 * echo out share item functionality
 *
 * @param $url
 * @param bool $title
 * @param bool $description
 */
function shareItem($url, $title = false, $description = false) {
    echo "
        <a href='http://www.facebook.com/sharer.php?u={$url}' title='". _e('SHARE_IN', true, ['{%1%}' => 'Facebook']) ."'   class='pop share-icon fab fa-facebook-f'></a>
        <a href='https://telegram.me/share/url?url={$url}'    title='". _e('SHARE_IN', true, ['{%1%}' => 'Telegram']) ."'   class='pop share-icon fa fa-paper-plane'></a>
        <a href='http://plus.google.com/share?url={$url}'     title='". _e('SHARE_IN', true, ['{%1%}' => 'GooglePlus']) ."' class='pop share-icon fab fa-google-plus-g'></a>
        <a href='http://www.twitter.com/share?url={$url}'     title='". _e('SHARE_IN', true, ['{%1%}' => 'Twitter']) ."'    class='pop share-icon fab fa-twitter'></a>
    ";
    if ($title && $description) {
        echo "<a href='http://www.linkedin.com/shareArticle?mini=true&url={$url}&title={$title}&summary={$description}' title='". _e('SHARE_IN', true, ['{%1%}' => 'LinedIn']) ."' class='pop share-icon fab fa-linkedin-in'></a>";
    }
}

function searchBackgroundImageUrl() {
    return siteroot() . 'images/'. setting('TEMPLATE__SEARCH_BACKGROUND_IMAGE');
}