<div class="modal-header">
    <h1><?php ($activation_method === 'mobile') ? _e('VERIFY_MOBILE') : _e('VERIFY_EMAIL') ?></h1>
</div>

<div class="modal-body">

    <form class="darker-form clearfix" data-click-checks-activation method="POST" action="<?= checkActivationCodeLink() ?>">

        <?= csrf_field() ?>

        <h5 class="mb-20"><?php ($activation_method === 'mobile') ? _e('ACTIVATION__TITLE_MOBILE') : _e('ACTIVATION__TITLE_EMAIL') ?></h5>

        <div class="col-sm-12 p-0 form-div">
            <div class="form-group form-group--float form-group--icon">
                <input type="text" id="activation_code" name="activation_code" class="form-control code-field">
                <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                <label for="activation_code"><?php _e('VERIFICATION_CODE') ?></label>
                <p class="help-block"></p>
            </div>
        </div>

        <div class="col-sm-12 p-0 form-div">
            <button type="submit" class="btn color2-bg no-shadow" data-default-text="<?php _e('CHECK') ?> <i class='fas fa-caret-left'></i>"> <?php _e('CHECK') ?> <i class='fas fa-caret-left'></i></button>
        </div>

    </form>


    <div class="resend-wrapper <?= $activation_method ?>" style="display: none">

        <h6  style="margin-bottom: 12px;"><?php _e('NOT_RECEIVED_ACTIVATION_CODE') ?></h6>
        <div class="activation-count-down">
            <p><?php _e('RESEND_AFTER_COUNTDOWN') ?></p>
            <div class="countdown-frame">
                <i class="fa fa-clock-o"></i>
                <div class="count-down"></div>
            </div>
        </div>

        <div class="resend-activation-code" style="display: none">
            <form data-submit-resends-activation-code method="POST" action="<?= sendActivationCodeLink() ?>">

                <?= csrf_field() ?>

                <input type="hidden" name="activation_method" value="<?= $activation_method ?>">
                <button type="submit" class="btn green-bg no-shadow submit-button"><?php _e('RESEND_ACTIVATION_CODE') ?> <i class="fa fa-repeat"></i></button>
            </form>
        </div>

    </div>

    <h4 class="after-resend-message" style="display: none"></h4>

</div>



