<?php
/** @var App\Pagination $pagination */
if ($pagination->totalPages() > 1) :
?>
    <div class="pagination full fwmpag">
        <?php if ($pagination->hasPrevPage()) : ?>
            <a rel='prev' title="<?php _e('PREV_PAGE') ?>" href="<?= $pagination->prevLink() ?>" class="prevposts-link prev-page"><i class="far fa-angle-right"></i> <?php _e('PREV_PAGE') ?><span></span></a>
        <?php endif; ?>
        <?php if ($pagination->hasStartDots()) : ?>
            <a> ... </a>
        <?php endif; ?>

        <?php
        for($i = ($pagination->currentPage() - 6); $i <= $pagination->middlePage(); $i++) :
            if ($i > 0 && $i <= $pagination->totalPages()) :
        ?>
            <?php if ($i == $pagination->currentPage()) : ?>
                <a class="current-page"><?= $i ?></a>
            <?php else: ?>
                <a href="<?= $pagination->linkToPage($i) ?>"><?= $i ?></a>
            <?php endif; ?>
        <?php
            endif;
        endfor;
        ?>

        <?php if ($pagination->hasMiddleDots()) : ?>
            <a> ... </a>
        <?php endif; ?>

        <?php if ($pagination->hasNextPage()) : ?>
            <a rel='next' title="<?php _e('NEXT_PAGE') ?>" href="<?= $pagination->nextLink() ?>" class="nextposts-link next-page"><?php _e('NEXT_PAGE') ?> <i class="far fa-angle-left"></i><span></span></a>
        <?php endif; ?>

    </div>
<?php endif; ?>