<div class="invoice-box">
    <table>
        <tbody>
            <tr class="top">
                <td colspan="2">
                    <table>
                        <tbody>
                        <tr>
                            <td class="title">
                                <img src="images/logo.png" alt="logo"> <?php _e('ORDER_RECEIPT') ?>
                            </td>
                            <td class="text-left">
                                <strong><?php _e('ORDER_ID') ?>: <?= $order->sale_order_id ?></strong><br>
                                <span><?= miladiToShamsi($order->date_created, 'j F Y ساعت H:i') ?></span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            <tr class="information">
                <td colspan="2">
                    <table>
                        <tbody>
                            <tr>
                                <td>
                                    <div class="strong"><strong><?php _e('BUYER_INFO') ?>: </strong></div>
                                    <span>
                                        <?php _e('USER_ID') ?>: &nbsp;<?= $order->user_id ?><br>
                                        <?php
                                        echo _e('USERNAME', true) . ": &nbsp;&nbsp;&nbsp;&nbsp; {$loggedUser->username()}";
                                        echo (!empty($loggedUser->TEL)) ? "<br>" . _e('PHONE', true) . " : &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; {$loggedUser->TEL}" : false;
                                        echo (!empty($loggedUser->EMAIL)) ? "<br>" . _e('MAIL', true) . " : &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;{$loggedUser->EMAIL}" : false;
                                        ?>
                                    </span>
                                </td>
                                <?php if ($order->isBacsGateway()) : ?>
                                    <td>
                                        <div class="strong"><strong><?php _e('BANK_INFO') ?></strong></div>
                                        <span><?= setting('BANK_PAYMENT_ADMIN_DESC'); ?></span>
                                    </td>
                                <?php endif; ?>
                                <?php if (!$order->isBacsGateway()) : ?>
                                    <td>
                                        <div class="strong"><strong><?php _e('BANK_GATEWAY') ?></strong></div>
                                        <img src="<?= $order->gatewayImageUrl() ?>" width="30">
                                        <span><?= $order->paymentKind() ?></span>
                                    </td>
                                <?php endif; ?>
                                <td>
                                    <div class="strong"><strong><?php _e('STATUS') ?></strong></div>
                                    <span>
                                        <?= $order->generalStatus() ?> <br>
                                        <?php if ($order->isBacsGateway()) : ?>
                                            <div><?php _e('EXPIRY') ?>: <span
                                                        style="direction: ltr"><?= miladiToShamsi(now(), 'Y/m/d ساعت H:i') ?></span></div>
                                        <?php endif; ?>
                                        <?php if (!$order->isBacsGateway()) : ?>
                                            <?php _e('SALE_REFRENCE_ID') ?>: <span style="direction: ltr"><?= ($order->sale_refrence_id) ?: ' ---------- ' ?></span>
                                        <?php endif; ?>
                                    </span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>

    <?php if ($order->isBacsGateway()) : ?>
        <div class="bacs-table-note">
            <h4> <?php _e('IMPORTANT_NOTE') ?>: </h4>
            <p>
                - <?php _e('BACS_PAY_TO_BANK_ACCOUNT') ?>
                <br>
                - <?php _e('BACS_SEND_PAYMENT_REFRENCE') ?>
            </p>
        </div>
    <?php endif; ?>

    <table>
        <tbody>
            <tr class="heading">
                <td><?php _e('ADS_ID') ?></td>
                <td><?php _e('ADS_TITLE') ?></td>
                <td><?php _e('PAYMENT__DESCRIPTION') ?></td>
                <td><?php _e('COST') ?></td>
            </tr>

            <?php
            /** @var App\OrderItem $item */
            foreach ($order->products() as $item) :
                ?>
                <tr class="item">
                    <td><?= $item->productId() ?></td>
                    <td><?= $item->name ?></td>
                    <td><?= $item->description() ?></td>
                    <td><?= price_format($item->subtotal()) ?></td>
                </tr>
            <?php endforeach; ?>

            <tr class="total">
                <td></td>
                <td style="padding-top:50px;">
                    <strong><?php _e('SUBTOTAL_COST') ?>:</strong>
                    <span><?= price_format($order->subtotal()) ?></span>
                </td>
            </tr>
            <tr class="total">
                <td></td>
                <td>
                    <strong><?php _e('APPLIED_DISCOUNTS') ?>: </strong>
                    <span>
                        <?php
                        /** @var App\OrderItem $coupon */
                        foreach ($order->coupons() as $coupon) :
                            ?>
                            - <?php _e('COUPON_DISCOUNT_DESCRIPTION', false, ['{%1%}' => price_format($coupon->discount()), '{%2%}' => $coupon->name]) ?>
                            <br>
                        <?php endforeach; ?>
                    </span>
                </td>
            </tr>
            <tr class="total">
                <td></td>
                <td style="padding-top: 30px;">
                    <strong><?php _e('TOTAL_COST') ?>: </strong>
                    <span><?= price_format($order->price) ?></span>
                </td>
            </tr>
        </tbody>
    </table>
</div>