<div class="list-single-main-item fl-wrap block_box" id="comments-section">
    <div class="list-single-main-item-title mb-0 level">
        <h3><?php _e('COMMENTS') ?></h3>
        <?php if ($comments) : ?>
            <a href="<?= $item->viewLink() ?>#add-review" class="btn color2-bg"> <?php _e('SEND_COMMENT') ?> <i class="fal fa-paper-plane"></i></a>
        <?php endif ?>
    </div>

    <div class="list-single-main-item_content fl-wrap">
        <div class="reviews-comments-wrap">

            <?php if (! $comments) : ?>
                <div class="no-item-with-button">
                    <p><?php _e('FIRST_COMMENT') ?></p>

                    <button href="<?= $item->viewLink() ?>#add-review" class="btn color2-bg no-shadow"> <?php _e('SEND_COMMENT') ?> <i class="fal fa-paper-plane"></i></button>
                </div>
            <?php endif; ?>

            <?php foreach ($comments as $comment) : ?>
                <div class="reviews-comments-item">
                    <div class="review-comments-avatar">
                        <img src="<?= user_logo($comment->USER_ID) ?>" alt="avatar">
                    </div>
                    <div class="reviews-comments-item-text fl-wrap">
                        <div class="reviews-comments-header fl-wrap">
                            <h4><a href="<?= $comment->user()->profileLink() ?>"><?= $comment->user()->publicName(false) ?></a></h4>
                            <div class="review-score-user">
                                <div class="reviews-comments-item-date"><span><i class="far fa-calendar-check"></i><?= per_date($comment->created_at, 'j F Y') ?></span></div>
                            </div>
                        </div>
                        <p class="gray"><?= safe($comment->text) ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>


<div class="list-single-main-item fl-wrap block_box" id="write-comment">
    <div class="list-single-main-item-title fl-wrap">
        <h3><?php _e('SEND_COMMENT') ?></h3>
    </div>

    <div id="add-review" class="add-review-box">

        <div class="clearfix"></div>

        <div class="form-message-placeholder colorful"></div>

        <?php if ($loggedUser) : ?>
        <div id="comment-form-wrapper">
            <form id="submit-comment" class="add-comment custom-form" action="" method="POST">

                <?= csrf_field() ?>

                <fieldset>
                    <div class="list-single-main-item_content fl-wrap">

                        <div class="form-group">
                            <textarea name="comment_body" id="comment_body" class="form-control" cols="40" rows="3" placeholder="<?php _e('YOUR_COMMENT') ?> ... "><?= input('comment_body') ?></textarea>
                            <label for="comment_body"></label>
                            <p class="help-block"></p>
                        </div>

                        <div class="clearfix"></div>

                        <?php if (isImageCaptcha()) : ?>
                            <div class="image-captcha form-div mt-20">
                                <img src="<?= captcha()->show('comment') ?>" id="comment_captcha" alt="comment captcha">
                                <div class="captcha-update-handler">
                                    <i class="fa fa-repeat" data-click-updates-captcha data-namespace="comment" data-target="#comment_captcha"></i>
                                </div>
                            </div>
                            <div class="col-xs-12 p-0 form-div">
                                <div class="form-group form-group--float form-group--icon">
                                    <input type="text" id="captcha" name="captcha" class="form-control captcha-field">
                                    <span class="input-icon-addon top-3"> <i class="fa fa-shield-alt"></i> </span>
                                    <label for="captcha"><?php _e('CAPTCHA_CODE') ?></label>
                                    <p class="help-block"></p>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if (isRecaptcha()) : ?>
                            <div class="g-recaptcha mt-20" id="comment-recaptcha"></div>
                            <div class="mini-next-line"></div>
                        <?php endif; ?>

                        <div class="clearfix"></div>

                        <div class="text-center">
                            <input type="hidden" name="action" value="send-comment">
                            <button type="submit" class="btn color2-bg pull-left" data-default-text="<?php _e('SEND_COMMENT') ?> <i class='fal fa-paper-plane'></i>"><?php _e('SEND_COMMENT') ?> <i class='fal fa-paper-plane'></i></button>
                        </div>
                    </div>
                </fieldset>
            </form>
        </div>
        <?php endif; ?>

        <?php if (! $loggedUser) : ?>
            <div class="not-logged-in">
                <div><i class="fa fa-user-alt-slash"></i></div>
                <p><?php _e('COMMENT_LOGIN', false, ['{%1%}' => loginLink()]) ?></p>
            </div>
        <?php endif; ?>
    </div>

</div>