<?php

use App\Ads;
use App\CategoryList;
use App\LocationList;
use App\Plan;

if (needsRegisterBeforeSubmit())
{
    /** @var App\User $loggedUser */
    if( ! $loggedUser || !$loggedUser->hasCorrectAccessLevel() || !$loggedUser->isActive() ){
        session()->error(_e('ADD_ADS_NOT_LOGGED_IN', true));
        redirect('auth');
    }
}

if(isPost() && isAjax()) {
    if(input('action') === 'submit') {
        $ajax_response = include('process/_ajax_submit.php');
    }

    if(input('action') === 'pay') {
        $ajax_response = include('process/_ajax_payment.php');
    }

    return $ajax_response;
}

$breadcrumbs = [
    _e('SUBMIT', true) => ''
];

$Ads = new Ads();
$Plan = new Plan();
if (inputs()->not_empty('plan_id') && setting('CAN_ADD_SPECIAL_ADS') === "YES") {
    $current_plan = $Plan->byId(input('plan_id'));
}
if (! $current_plan) {
    $current_plan = $Plan->findFreePlan();
}
$categories = (new CategoryList())->categories();
$states = (new LocationList())->states();
$plans = (setting('CAN_ADD_SPECIAL_ADS') === "YES") ? $Plan->all('PLAN_PRICE ASC, PLAN_STARS ASC') : [$current_plan];
$preuploaded_images_names = [];
$custom_fields = null;

$js_variables = [
    'images_count' => $current_plan->MAX_IMG_COUNT,
    'preuploaded_images_count' => 0,
    'preuploaded_images_names' => json_encode($preuploaded_images_names),
    'GLOBE__username_type' => usernameType(),
    'default_lat' => setting('DEFAULT_LAT'),
    'default_long' => setting('DEFAULT_LONG'),
    'submit_url' => submitLink() . '?action=submit',
    'gateway_url' => submitLink() . '?action=pay',
];

$default_gateway = setting('DEFAULT_GATEWAY');