<?php

use App\Ads;
use App\CustomFields;
use App\Favourites;
use App\Tag;
use App\Visitor;
use App\User;

$stats = new Visitor();
$stats->addCounter();

$ads_id = str_replace('.html', '', input('id'));
$slug = str_replace('.html', '', urldecode(input('slug')));

$Ads = new Ads();
$Tags = new Tag();

$ads = $Ads->ads_by_id($ads_id, false);
if (!$ads || !is_numeric($ads_id)) {
    abort(404);
}
if ((empty($slug) || $slug !== $ads->ADS_SLUG) && input('q') !== "print") {
    redirect301($ads->viewLink());
}

$allowable_status = array(2, 5, 100);
$ads_status = $ads->ads_general_status(true);
$is_preview = false;

if (! in_array($ads_status, $allowable_status)) {
    /** @var App\User $loggedUser */
    if (!$loggedUser || (!$loggedUser->hasAccessTo('ADS_MANAGE') && !$loggedUser->owns($ads))) {
        abort();
    }

    $is_preview = true;
}
$is_expired = ($ads_status === 5);
$is_disabled = ($ads_status === 100);
$should_show_partial = ($is_expired || $is_disabled);


$ads->checkStatus();

if ($ads->PARENT != 0) {
    $parent = $ads->findSubcategoryParent();
}

$Favourites = new Favourites();
$favourite = $Favourites->find($ads->ADS_ID, $loggedUser->USER_ID);

$printable = (input('q') === "print");
$printClass = $printable ? "hide" : "";

$cookie_name = 'vt_ads_' . md5($ads->ADS_ID);

$user = $User->findById($ads->USER_ID);
if (! $user) {
    $user = new User();
}

$ads->incrementView();

$comments = $ads->comments();

$page_title = $ads->ADS_TITLE . "-" . setting('SITE_TITLE');
$page_canonical_link = $ads->viewLink();
$page_keywords = $Tags->commaSeparated($ads->ADS_ID, 'ads');
$page_description = strip_tags(limit_word($ads->ADS_DESCRIPTION, 30));
$page_no_index = ($printable) ? true : false;
$page_author = siteroot();

$page__has_maps = true;
$load_toastr = true;

$open_graph_settings = [
    'twitter:title' => $ads->ADS_TITLE,
    'twitter:image' => $ads->featuredImage('thumb'),
    'twitter:url' => $ads->viewLink(),
    'og:title' => $ads->ADS_TITLE,
    'og:image' => $ads->featuredImage('thumb'),
    'og:url' => $ads->viewLink()
];

$owner_email = $ads->ADS_OWNER_EMAIL;
$owner_phone = $ads->ADS_OWNER_PHONE;
if ($user && empty($owner_email)) {
    $owner_email = $user->officialEmail();
}
if ($user && empty($owner_phone)) {
    $owner_phone = $user->officialMobile();
}


if (isPost()) {
    if (input('action') === 'fetch-info') {
        $ajax_response = include('process/property/_info.php');

        return $ajax_response;
    }

    if (input('action') === 'send-comment') {

        $item_id = $ads->ADS_ID;

        $comment_type = 'ads';

        $ajax_response = include('process/comment/_store.php');

        return $ajax_response;
    }

    if (input('action') == 'submit-contact') {
        $ajax_response = include('process/property/_contact.php');

        return $ajax_response;
    }

    if (input('action') === 'send-report') {
        $ajax_response = include('process/property/_report.php');

        return $ajax_response;
    }
}


$breadcrumbs = [
    $ads->CATEGORY_NAME => $ads->categoryLink()
];
if (! $parent) {
    $breadcrumbs[$ads->SUBCATEGORY_NAME] = $ads->subCategoryLink();
}
if ($parent) {
    $breadcrumbs[$parent->SUBCATEGORY_NAME] = $parent->subCategoryLink($ads->CATEGORY_SLUG);
    $breadcrumbs[$ads->SUBCATEGORY_NAME] = $ads->subsidiaryLink($parent->SUBCATEGORY_SLUG, false, $ads->CATEGORY_SLUG, $ads->SUBCATEGORY_SLUG);
}

$breadcrumbs[safe($ads->ADS_TITLE)] = '';

$CustomFields = new CustomFields();
$custom_fields = $CustomFields->getValues($ads->ADS_ID);

$tags = $Tags->findAll($ads->ADS_ID);

$related_items = $ads->relatedItems($ads->SUBCAT_ID, $current_page->setting('related-items-count'));

$js_variables = [
    'map_show' => (! $should_show_partial && $ads->shouldShowMap()) ? 2 : 1,
    'map_latitude' => $ads->LATITUDE,
    'map_longitude' => $ads->LONGITUDE,
    'map_title' => $ads->ADS_TITLE,
    'page__enable_voting' => ($current_page->setting('enable-voting') === 'YES') ? 2 : 1,
    'page__link_id' => $ads->ADS_ID,
    'logged_in' => $loggedUser ? 2 : 1,
    'submit_contact_url' => $ads->viewLink() . '?action=submit-contact',
];

$header_actions = [
    _e('EDIT_ADS', true) => [
        'link' => $ads->EditLinkForAdmin(),
        'icon' => 'fa-edit',
        'class' => 'green-bg'
    ]
];

$is_favoured_by_user = $ads->isFavouredByCurrentUser();