<?php

use App\Ads;
use App\Post;
use App\RSS;

$urlParts = currentRelativeURL(false, true, true);

$available_contents = ['newest', 'posts'];
$requested_content = $urlParts[1];

if (! in_array($requested_content, $available_contents)) {
    if (is_numeric($requested_content) && empty($urlParts[2])) {
        $requested_content = 'category';
        $category_id = $urlParts[1];
    }
    if (is_numeric($requested_content) && ! empty($urlParts[2]) && is_numeric($urlParts[2])) {
        $requested_content = 'subcategory';
        $category_id = $urlParts[1];
        $subcategory_id = $urlParts[2];
    }
}

if (! empty ($urlParts[3])) {
    abort();
}

$Feed = new RSS();
$Ads = new Ads();

$channel_image = imagesRoot() . 'logo.png';

if ($requested_content === 'newest') {
    $feed = $Feed->createChannel('تازه ترین آگهی ها', rssRoute('new-ads'), setting('SITE_TITLE'), $channel_image, rssRoute('new-ads'));

    $adss = $Ads->latest(false, setting('RSS_POSTS_LIMIT'), true);
    foreach ($adss as $ads) {
        $feed->addAdsItem($ads);
    }

    $feed->generate();
}

if ($requested_content === 'posts') {
    $feed = $Feed->createChannel('پست های سایت', blogLink(), setting('SITE_TITLE'), $channel_image, rssRoute('posts'));

    $Post = new Post();
    $posts = $Post->forBlog(0, null, setting('RSS_POSTS_LIMIT'));
    foreach ($posts as $post) {
        $feed->addPostItem($post);
    }

    $feed->generate();
}

if ($requested_content === 'category') {
    $feed = $Feed->createChannel('تمام آگهی ها', rssRoute('category', $category_id), setting('SITE_TITLE'), $channel_image, rssRoute('category', $category_id));

    $adss = $Ads->forCategory($category_id, false, setting('RSS_POSTS_LIMIT'));
    foreach ($adss as $ads) {
        $feed->addAdsItem($ads);
    }

    $feed->generate();
}

if ($requested_content === 'subcategory') {
    $feed = $Feed->createChannel('تمام آگهی ها - کدیزاین', rssRoute('subcategory', $category_id, $subcategory_id), setting('SITE_SUBTITLE'), $channel_image, rssRoute('subcategory', $category_id, $subcategory_id));

    $adss = $Ads->forParentSubcategory($subcategory_id, false, setting('RSS_POSTS_LIMIT'));
    foreach ($adss as $ads) {
        $feed->addAdsItem($ads);
    }

    $feed->generate();
}