<?php

use App\ItemResource;
use App\User;

$identifier = input('id');
$User = new User();

$user = $User->findByUuid($identifier);

if (!$user) {
    abort();
}

$has_contact_form = true;
if (! $user->email()) {
    $has_contact_form = false;
}
if (registerNeedsActivation() && ! $user->hasVerifiedEmail()) {
    $has_contact_form = false;
}

if ($current_page->setting('enable-send-email') != 'YES') {
    $has_contact_form = false;
}

/** @var App\Page $current_page */
if (isPost() && isAjax() && input('action') == 'submit-contact') {
    $ajax_response = include('process/contact/_profile_send.php');

    return $ajax_response;
}

/** @var App\Page $current_page */
if (isPost() && isAjax() && input('action') == 'fetch-info') {
    $ajax_response = include('process/profile/_info.php');

    return $ajax_response;
}

$page_title = _e('USER_PROFILE', true, array('{%1%}' => $user->publicName(false)));
$page_canonical_link = $user->profileLink();

$sql = $user->visualAds(false, true);
$ItemResource = new ItemResource(App\Ads::class, $user->profileLink());
$resource = $ItemResource->fetchItems($sql, $current_page->setting('item-per-page'));

$resource_items = $resource->items();
loadBulkCustomFields($resource_items);

$user_ads_count = $user->countAllAds(true);

$user_ads_views = $user->allAdsViews();

$user->incrementProfileViews();

$js_variables = [
    'submit_url' => $user->profileLink() . '?action=submit-contact',
    'logged_in' => $loggedUser ? 2 : 1,
    'has_contact_form' => $has_contact_form ? 2 : 1
];

$breadcrumbs = [
    $page_title => ''
];

