<?php

use App\Exception\GateWayException;
use App\GateWay;

$query_parts = getQueryStrings();

$method = data_get($query_parts, 'method');

$gateway_namespace = "App\\{$method}";
$errors_array = [];
try {
    $GateWay = new GateWay($gateway_namespace, $method, inputs());
    $GateWay->callback();

    $successful_payment = true;
    $error = null;
    $page_title = _e('BACK_FROM', true) . $GateWay->gateway()->name() . '|' . setting('SITE_TITLE');
} catch (GateWayException $e) {
    $errors_array = $e->errors();
    $error = data_get($errors_array, 'status');

    if ($error === 'GATEWAY_NOT_FOUND') {
        abort();
    }

    $successful_payment = false;
    $page_title = _e('BACK_FROM_GATEWAY', true) . '|' . setting('SITE_TITLE');
}