<?php

use App\Ads;
use App\CategoryList;
use App\CustomFields;
use App\ItemResource;
use App\LocationList;
use App\SearchEngine;
use App\Visitor;

$search = new SearchEngine();

$search->state = strip_tags(htmlspecialchars(input('state')));
$search->city = strip_tags(htmlspecialchars(input('city')));
$search->category = strip_tags(htmlspecialchars(input('category')));
$search->subcategory = strip_tags(htmlspecialchars(input('subcategory')));
$search->subsidiary = strip_tags(htmlspecialchars(input('subsidiary')));
$search->keyword = strip_tags(htmlspecialchars(input('keyword')));
$search->order = strip_tags(htmlspecialchars(input('or')));

cookie()->deleteState();
cookie()->deleteCity();
if (not_empty($search->state)) {
    cookie()->setState($search->state);
}
if (not_empty($search->city)) {
    cookie()->setCity($search->city);
}

$pre_search_check_condition = CustomFields::find_one($search->primary_condition_check());
if ($pre_search_check_condition->total > 0) {
    $search->has_custom_fields = true;
    $search->loadCustomFields();
}

$query_text_ads = $search->set_text_ads_query();

$query_main_ads = $search->set_main_ads_query();

$query_special_ads = $search->setSpecialQuery();

$page_url = $search->getUrl();

$stats = new Visitor();
$stats->addCounter();
$page_canonical_link = searchLink();

$ItemResource = new ItemResource(Ads::class, searchLink(), $page_url);

$resource = $ItemResource->fetchItems($query_main_ads, $current_page->setting('item-per-page'));

$resource_items = $resource->items();
loadBulkCustomFields($resource_items);

$CategoryList = new CategoryList();
$LocationList = new LocationList();

$current_category = $current_subcategory = $current_subsidiary = $current_state = $current_city = null;
$has_category_filter = $has_location_filter = false;

if (inputs()->not_any('category')) {
    $current_category = $CategoryList->findCategory(input('category'));

    $has_category_filter = ($current_category) ? $current_category->name() : false;
}
if (inputs()->not_any('subsidiary')) {
    $current_subsidiary = $CategoryList->findSubcategory(input('subsidiary'));

    $current_subcategory = $CategoryList->findParentSubcategoryFor(input('subsidiary'));

    $has_category_filter = ($current_subsidiary && $current_subcategory) ? $current_subsidiary->name() : false;
} elseif (inputs()->not_any('subcategory')) {
    $current_subcategory = $CategoryList->findSubcategory(input('subcategory'));

    $has_category_filter = ($current_subcategory) ? $current_subcategory->name() : false;
}

if (inputs()->not_empty('city')) {
    $current_city = $LocationList->findCity(input('city'));

    $current_state = $LocationList->findStateFor(input('city'));

    $has_location_filter = ($current_city && $current_state) ? $current_city->name() : false;
}

$CustomFields = new CustomFields();
$custom_fields = $CustomFields->getFieldsSmartly(optional($current_category)->id(), optional($current_subcategory)->id(), optional($current_subsidiary)->id());

$breadcrumbs = [];
$title_array = [];
if ($current_state) {
    $breadcrumbs[$current_state->name()] = $current_state->viewLink();
    $title_array['location'] = $current_state->name();
}
if ($current_city) {
    $breadcrumbs[$current_city->name()] = $current_city->viewLink();
    $title_array['location'] = $current_city->name();
}
if (! $current_state && ! $current_city) {
    $breadcrumbs[_e('ALL_LOCATIONS', true)] = searchLink();
    $title_array['location'] = _e('COUNTRY_NAME', true);
}
if ($current_category) {
    $breadcrumbs[$current_category->name()] = $current_category->viewLink();
    $title_array['category'] = $current_category->name();
}
if ($current_subcategory) {
    $breadcrumbs[$current_subcategory->name()] = $current_subcategory->viewLink($current_category);
    $title_array['category'] = $current_subcategory->name();
}
if ($current_subsidiary) {
    $breadcrumbs[$current_subsidiary->name()] = $current_subsidiary->viewLink($current_category, $current_subcategory);
    $title_array['category'] = $current_subsidiary->name();
}

if (! $title_array['category']) {
    $title_array['category'] = _e('ALL_ADS', true);
}

$categories = $CategoryList->categories();

$states = $LocationList->states();

$slider_ads = loadVitrinAds($query_special_ads);

//$page_title = (! empty($search->keyword)) ? $search->keyword . '|' : _e('SEARCH', true) . '|'; ;
//$page_title .= setting('SITE_TITLE');
$search_title = _e('SEARCH_TITLE', true, ['{%1%}' => $title_array['category'], '{%2%}' => $title_array['location']]);
$page_title =  $search_title . ' | ' . setting('SITE_TITLE');

