<?php

use App\ItemResource;
use App\Post;
use App\Tag;

$tag_id = input('tag');
$slug = input('slug');

$Tags = new Tag();

if (is_numeric($tag_id)) {
    $tag = $Tags->byId($tag_id);
} else {
    $tag = $Tags->find($slug, true);
}

if (! $tag) {
    abort();
}

$tag->setType('post');
if (empty($slug) || $slug !== $tag->TAG_SLUG) {
    redirect301($tag->viewLink());
}

$sql = (new Post())->forTag($tag->TAG_ID, false, true);

$ItemResource = new ItemResource(Post::class, $tag->viewLink());
$resource = $ItemResource->fetchItems($sql, $current_page->setting('item-per-page'));

$resource_items = $resource->items();


$page_title       = $tag->TAG_NAME .' |'. setting('SITE_TITLE');
$page_keywords    = $tag->TAG_NAME .', '. setting('SEO_KEYWORDS');
$page_description = $tag->TAG_NAME .' -'. setting('SEO_DESCRIPTION');
$page_canonical_link = $tag->viewLink();

$breadcrumbs = [
    _e('BLOG', true) => blogLink(),
    $tag->TAG_NAME => ''
];