<?php

use App\Post;
use App\Tag;
use App\Visitor;

$post_id = str_replace('.html', '', input('id'));
$slug = str_replace('.html', '', urldecode(input('slug')));

$Posts = new Post();
$Tags = new Tag();

$post = $Posts->byIdWithCategory($post_id);
if (! $post) {
    abort();
}
if (empty($slug) || $slug !== $post->POST_SLUG) {
    redirect301($post->viewLink());
}

if (isPost()) {
    if (input('action') === 'send-comment') {
        $item_id = $post->POST_ID;

        $comment_type = 'post';

        $ajax_response = include('process/comment/_store.php');

        return $ajax_response;
    }

    abort();
}

$post->incrementViews();

$stats = new Visitor();
$stats->addCounter();

$page_title = $post->TITLE . "|" . setting('SITE_TITLE');
$page_keywords = (empty($post->POST_META_KEYWORDS)) ? $Tags->commaSeparated($post->POST_ID, 'post') : $post->POST_META_KEYWORDS;
$page_description = (empty($post->POST_META_DESCRIPTION)) ? limit_word(strip_tags($post->POST_TEXT), 156) : $post->POST_META_DESCRIPTION;
$page_canonical_link = $post->viewLink();

$tags = $Tags->findAll($post->POST_ID, 'post');

if ($current_page->setting('show-comments') === 'YES') {
    $comments = $post->comments();
}

$has_images = (bool) $post->featuredImage('main', false);

$open_graph_settings = [
    'twitter:title' => $post->TITLE,
    'twitter:image' => $post->featuredImage('main'),
    'twitter:url' => $post->viewLink(),
    'og:title' => $post->TITLE,
    'og:image' => $post->featuredImage('main'),
    'og:url' => $post->viewLink()
];

$breadcrumbs = [
    _e('BLOG', true)      => blogLink(),
    $post->categoryName() => blogRoutes('category', [$post->CATEGORY_ID, $post->CATEGORY_SLUG]),
    $post->TITLE          => ''
];

$header_actions = [
    _e('EDIT_POST', true) => [
        'link' => $post->EditLink(),
        'icon' => 'fa-edit',
        'class' => 'green-bg'
    ]
];

$js_variables = [
    'page__enable_voting' => ($current_page->setting('enable-voting') === 'YES') ? 2 : 1,
    'page__link_id' => $post->id()
];