<?php

use App\ItemResource;
use App\Post;
use App\PostCategory;
use App\Visitor;

$category_id = 0;
if (inputs()->not_empty('categoryId')) {
    $PostCategory = new PostCategory();
    $category = $PostCategory->byId(input('categoryId'));
    $category_id = $category->CATEGORY_ID;
}

$stats = new Visitor();
$stats->addCounter();

$page_canonical_link = blogLink();

if (not_empty($category_id)) {
    $page_title = $category->CATEGORY_NAME;
    $page_keywords = $category->META_KEYWORDS;
    $page_description = $category->META_DESCRIPTION;
    $page_canonical_link = $category->viewLink();
}

$breadcrumbs = [];
if (isset($category)) {
    $breadcrumbs[_e('BLOG', true)] = blogLink();
    $breadcrumbs[$category->CATEGORY_NAME] = '';
} else {
    $breadcrumbs[_e('BLOG', true)] = '';
}

$searchKeyword = strip_tags(htmlspecialchars(input('search')));

$base_url = (isset($category)) ? $category->viewLink() : blogLink();
$search_query = inputs()->not_empty('search') ? "search=".$searchKeyword : null;

$sql = (new Post())->forBlog($category_id, $searchKeyword, false, true);

$ItemResource = new ItemResource(Post::class, $base_url, $search_query);
$resource = $ItemResource->fetchItems($sql, $current_page->setting('item-per-page'));

$resource_items = $resource->items();

$title = (isset($category)) ? $category->CATEGORY_NAME : _e('BLOG', true);
if (inputs()->not_empty('search')) {
    $title = _e('SEARCH_RESULTS_FOR', true, ['{%1%}' => $searchKeyword]);
}
