<?php

use App\AuthToken;
use App\ReCaptcha;
use App\Validate;
use App\Visitor;

$stats = new Visitor();

/** @var App\User $loggedUser */
if ($loggedUser) {
    redirect('root');
}

$user = null;

if (input('action') === 'reset' && inputs()->not_empty('token')) {
    $token = input('token');
    $AuthToken = new AuthToken('forgot');
    $user_id = $AuthToken->verify($token);

    $user = $User->findById($user_id);

    if (! $user) {
        session()->error(_e('WRONG_RESET_PASSWORD_TOKEN', true));
        redirect(loginLink());
    }

    session()->put(config('forgot_password/token_session'), $token);
    session()->put(config('forgot_password/username_session'), $user->username());
    session()->put(config('forgot_password/token_type_session'), 'forgot');

    redirect(resetPasswordRoot());
}

if (input('action') !== 'reset' && (session()->is_empty(config('forgot_password/token_session')) || session()->is_empty(config('forgot_password/username_session')))) {
    abort();
}

// change password
if (inputs()->not_empty('forgot_token') && inputs()->not_empty('forgot_username')) {
    if (! token()->check()) {
        redirect('refer');
    }

    $ReCaptcha = new ReCaptcha();
    if (! $ReCaptcha->verify('reset-password')) {
        session()->error($ReCaptcha->error());
        redirect('refer');
    }

    $validation = new Validate();
    $validation = $validation->check($_POST, array(
        'password' => array(
            'name' => _e('PASSWORD', true),
            'prefix' => _e('ENTERING', true),
            'required' => true,
            'min' => 6
        ),
        'password_confirm' => array(
            'name' => _e('PASSWORD_CONFIRMATION', true),
            'prefix' => _e('ENTERING', true),
            'required' => true,
            'matches' => 'password'
        )
    ));

    if (!$validation->passed()) {
        session()->error($validation->errors(), true);
        redirect('refer');
    }

    $token_type = (session()->not_empty(config('forgot_password/token_type_session'))) ? session()->get(config('forgot_password/token_type_session')) : 'forgot';

    $token = input('forgot_token');
    $AuthToken = new AuthToken($token_type);
    $user_id = $AuthToken->verify($token);
    $user = $User->findById($user_id);

    if (!$user || $user->username() != input('forgot_username')) {
        session()->delete(config('forgot_password/token_session'));
        session()->delete(config('forgot_password/username_session'));
        session()->delete(config('forgot_password/token_type_session'));

        session()->error(_e('WRONG_RESET_PASSWORD_TOKEN', true));
        redirect(loginLink());
    }

    $user->changePassword(input('password'));
    session()->success(_e('PASSWORD_CHANGED_SUCCESSFUL', true));
    redirect(loginLink());
}