<?php

use App\AuthToken;
use App\User;
use App\Visitor;

$stats = new Visitor();

/** @var App\User $loggedUser */
if ($loggedUser) {
    redirect('root');
}

if (isPost() && token()->check()) {
    $AuthToken = new AuthToken('forgot_minimal');
    $User = new User();

    $token = input('activation_code');
    $user_id = $AuthToken->verify($token);
    $user = $User->findById($user_id);

    if (! $user) {
        session()->error(_e('WRONG_RESET_PASSWORD_TOKEN', true));
        redirect('refer');
    }

    session()->put(config('forgot_password/token_session'), $token);
    session()->put(config('forgot_password/username_session'), $user->username());
    session()->put(config('forgot_password/token_type_session'), 'forgot_minimal');
    redirect(resetPasswordRoot());
}