<?php

use App\AuthToken;
use App\Visitor;

$stats = new Visitor();

/** @var App\User $loggedUser */
if (!$loggedUser || !$loggedUser->hasCorrectAccessLevel() || !$loggedUser->isPendingActivation() || !canActivateWithSMS()) {
    redirect('root');
}

if (isPost() && isAjax() && input('action') === 'verify') {
    $AuthToken = new AuthToken('activation');

    if ($loggedUser->verifyActivationCode(input('activation_code'))) {
        $ajax_response = ajaxSuccessResponse([
            'message' => _e('ACCOUNT_ACTIVATION_SUCCESSFUL', true),
            'type' => 'redirect',
            'url' => submitLink(),
        ]);

        return $ajax_response;
    }

    $ajax_response = ajaxErrorResponse(_e('WRONG_CODE', true));
    return $ajax_response;
}

$resend_time = $loggedUser->resendAuthTokenTime('activation');
