<?php

use App\AuthToken;
use App\Visitor;

$stats = new Visitor();

/** @var App\User $loggedUser */
if( ! $loggedUser || ! $loggedUser->hasCorrectAccessLevel() || ! $loggedUser->isPendingActivation() || ! canActivateWithEmail() ){
    redirect('root');
}

if(isPost() && input('action') === 'verify') {
    $AuthToken = new AuthToken('activation');
    if( $loggedUser->verifyActivationCode( input('activation_code') ) ) {
        session()->success(_e('ACCOUNT_ACTIVATION_SUCCESSFUL', true));
        redirect(submitLink());
    }

    session()->error(_e('WRONG_CODE', true));
    redirect('refer');
}

$resend_time = $loggedUser->resendAuthTokenTime('activation');
