<?php

use App\Ads;
use App\ItemResource;
use App\Tag;

$tag  = input('tag');
$slug = input('slug');

$Tags = new Tag();
if(is_numeric($tag)){
    $tag = $Tags->byId($tag);
} else {
    $tag = $Tags->find($slug, true);
}

if (! $tag) {
    abort();
}

$tag->setType('ads');
if (empty($slug) || $slug !== $tag->TAG_SLUG) {
    redirect301($tag->viewLink());
}

$sql = (new Ads())->findByTag($tag->TAG_ID, false, false, false, true);

$ItemResource = new ItemResource(Ads::class, $tag->viewLink(), addOrderQueryString());
$resource = $ItemResource->fetchItems($sql, $current_page->setting('item-per-page'));

$resource_items = $resource->items();
loadBulkCustomFields($resource_items);


$page_title       = $tag->TAG_NAME .' |'. setting('SITE_TITLE');
$page_keywords    = $tag->TAG_NAME .', '. setting('SEO_KEYWORDS');
$page_description = $tag->TAG_NAME .' -'. setting('SEO_DESCRIPTION');
$page_canonical_link = $tag->viewLink();

$breadcrumbs = [
    _e('ADSS', true) => searchLink(),
    $tag->TAG_NAME => ''
];