<?php

use App\Ads;
use App\CategoryList;
use App\ItemResource;

$catIdentifier = input('cat');
$subCatIdentifier = input('subCat');

$CategoryList = new CategoryList();

if (is_numeric($catIdentifier)) {
    $thisCategory = $CategoryList->findCategory($catIdentifier);
} else {
    $thisCategory = $CategoryList->findCategory($catIdentifier, true);
}

if (! $thisCategory) {
    abort();
}

if(is_numeric($subCatIdentifier)){
    $thisSubCategory = $CategoryList->findSubcategory($subCatIdentifier);
} else {
    $thisSubCategory = $CategoryList->findSubcategory($subCatIdentifier, true);
}

if (! $thisSubCategory) {
    abort();
}

$widgets_data = [
    'category_id'    => $thisCategory->ID,
    'subcategory_id' => $thisSubCategory->ID,
    'subsidiary_id'  => 0
];

$page_title  = $thisSubCategory->SUBCATEGORY_NAME .' | '. setting('SITE_TITLE');
$page_title .= (! isFirstPage()) ? ' - ' . _e('PAGE_NO', true, ['{%1%}' => input('page')]) : false;
$page_keywords = (! empty($thisSubCategory->SUBCATEGORY_KEYWORDS)) ? $thisSubCategory->SUBCATEGORY_KEYWORDS : setting('SEO_KEYWORDS');
$page_description = (! empty($thisSubCategory->SUBCATEGORY_DESCRIPTION)) ? $thisSubCategory->SUBCATEGORY_DESCRIPTION : setting('SEO_DESCRIPTION');
$page_canonical_link = $base_link = $thisSubCategory->viewLink($thisCategory);
$page_canonical_link .= (! isFirstPage()) ? "?&page=" . input('page') : false;
$page_next_link = (isFirstPage()) ? $base_link . "?&page=2" : $base_link . "?&page=" . (input('page') + 1);
$page_prev_link = (! isFirstPage()) ? $base_link . "?&page=" . (input('page') - 1) : false;

$sql = ads()->forParentSubcategory($thisSubCategory->ID, false, false, false, true);

$ItemResource = new ItemResource(Ads::class, $thisSubCategory->viewLink($thisCategory), addOrderQueryString());
$resource = $ItemResource->fetchItems($sql, $current_page->setting('item-per-page'));

$resource_items = $resource->items();
loadBulkCustomFields($resource_items);

$breadcrumbs = [
    _e('CATEGORIES', true) => categoriesLink(),
    $thisCategory->CATEGORY_NAME => $thisCategory->viewLink(),
    $thisSubCategory->SUBCATEGORY_NAME => ''
];

$subcategories = $CategoryList->childSubCategoriesFor($thisSubCategory->ID);

$slider_ads = loadVitrinAds(ads()->forParentSubcategory($thisSubCategory->ID, false, setting('VITRIN_ITEMS_COUNT'), false, true, true));

if (! empty($thisSubCategory->SUBCATEGORY_SEO_TITLE)) {
    $page_title = $thisSubCategory->SUBCATEGORY_SEO_TITLE;
}