<?php

use App\Ads;
use App\ItemResource;
use App\LocationList;

$location_id = input('id');
$location_slug = input('slug');

$LocationList = new LocationList();

$thisState = $LocationList->findState($location_id);

$is_state = true;
$thisCity = null;

$page_keywords = $thisState->STATE_NAME;
$page_title = _e('STATE_ADS', true, ['{%1%}' => $thisState->STATE_NAME]) . " | " . setting('SITE_TITLE');
$page_canonical_link = $thisState->viewLink();


$sql = ads()->forState($thisState->ID, false, false, false, true);

$ItemResource = new ItemResource(Ads::class, $thisState->viewLink(), addOrderQueryString());
$resource = $ItemResource->fetchItems($sql, $current_page->setting('item-per-page'));

$resource_items = $resource->items();
loadBulkCustomFields($resource_items);


$breadcrumbs = [
    $thisState->STATE_NAME => ''
];

$cities = $LocationList->citiesFor($thisState->ID);

$slider_ads = loadVitrinAds(ads()->forState($thisState->ID, false, setting('VITRIN_ITEMS_COUNT'), false, true, true));