<?php

use App\Ads;
use App\ItemResource;
use App\LocationList;

$location_id = input('id');
$location_slug = input('slug');

$LocationList = new LocationList();
$thisCity = $LocationList->findCity($location_id);
$thisState = $thisCity->state();

$page_keywords = "{$thisCity->CITY_NAME}, {$thisState->STATE_NAME}";
$page_title = _e('CITY_ADS', true, ['{%1%}' => $thisCity->CITY_NAME]) . " | " . setting('SITE_TITLE');
$page_canonical_link = $thisCity->viewLink();

$sql = ads()->forCity($thisCity->ID, false, false, false, true);

$ItemResource = new ItemResource(Ads::class, $thisCity->viewLink(), addOrderQueryString());
$resource = $ItemResource->fetchItems($sql, $current_page->setting('item-per-page'));

$resource_items = $resource->items();
loadBulkCustomFields($resource_items);

$breadcrumbs = [
    'استان '. $thisState->STATE_NAME => $thisState->viewLink(),
    $thisCity->CITY_NAME => ''
];

$slider_ads = loadVitrinAds(ads()->forCity($thisCity->ID, false, setting('VITRIN_ITEMS_COUNT'), false, true, true));