<?php

use App\Ads;
use App\CategoryList;
use App\ItemResource;

$category_id = input('cat');
$slug = input('slug');

$CategoryList = new CategoryList();

if (is_numeric($category_id)) {
    $thisCategory = $CategoryList->findCategory($category_id);
} else {
    $thisCategory = $CategoryList->findCategory($category_id, true);
}

if (! $thisCategory) {
    abort();
}

if (empty($slug) || $slug !== $thisCategory->CATEGORY_SLUG) {
    redirect301($thisCategory->viewLink());
}

$widgets_data = [
    'category_id'    => $thisCategory->ID,
    'subcategory_id' => 0,
    'subsidiary_id'  => 0
];

$page_title = $thisCategory->CATEGORY_NAME . ' | ' . setting('SITE_TITLE');
$page_title .= (!isFirstPage()) ? ' - ' . _e('PAGE_NO', true, ['{%1%}' => input('page')]) : false;
$page_keywords = (!empty($thisCategory->CATEGORY_KEYWORDS)) ? $thisCategory->CATEGORY_KEYWORDS : setting('SEO_KEYWORDS');
$page_description = (!empty($thisCategory->CATEGORY_DESCRIPTION)) ? $thisCategory->CATEGORY_DESCRIPTION : setting('SEO_DESCRIPTION');
$page_canonical_link = $base_link = $thisCategory->viewLink();
$page_canonical_link .= (!isFirstPage()) ? "?&page=" . input('page') : false;
$page_next_link = (isFirstPage()) ? $base_link . "?&page=2" : $base_link . "?&page=" . (input('page') + 1);
$page_prev_link = (!isFirstPage()) ? $base_link . "?&page=" . (input('page') - 1) : false;

$sql = ads()->forCategory($thisCategory->ID, false, false, false, true);

$ItemResource = new ItemResource(Ads::class, $thisCategory->viewLink(), addOrderQueryString());
$resource = $ItemResource->fetchItems($sql, $current_page->setting('item-per-page'));

$resource_items = $resource->items();
loadBulkCustomFields($resource_items);

$breadcrumbs = [
    _e('CATEGORIES', true) => categoriesLink(),
    $thisCategory->CATEGORY_NAME => ''
];

$subcategories = $CategoryList->parentSubCategoriesFor($thisCategory->ID);

$slider_ads = loadVitrinAds(ads()->forCategory($thisCategory->ID, false, setting('VITRIN_ITEMS_COUNT'), false, true, true));

if (! empty($thisCategory->CATEGORY_SEO_TITLE)) {
    $page_title = $thisCategory->seoTitle();
}
