<?php

use App\Ads;
use App\Plan;

$Ads = new Ads();
$Plan = new Plan();

/** @var mixed $page_parameter :: came from page url */
$ads = $Ads->ads_by_id($page_parameter, false);

/** @var App\User $loggedUser */
if( ! $ads || ! $loggedUser->owns($ads) || ! $ads->isPendingPayment() ) {
    abort();
}

if (isPost() && isAjax() && input('action') == 'pay') {
    $ajax_response = include('process/_ajax_payment.php');

    return $ajax_response;
}

$js_variables = [
    'gateway_url' => $ads->paymentLink() . '?action=pay'
];

$breadcrumbs = [
    _e('MY_ACCOUNT', true) => dashboardLink(),
    _e('MY_ITEMS', true) => myListingsLink(),
    _e('GO_TO_PAYMENT', true) => ''
];