<?php

use App\Ads;
use App\Plan;

$Ads = new Ads();
$Plan = new Plan();

/** @var mixed $page_parameter :: came from page url */
$ads = $Ads->ads_by_id($page_parameter, false);

if( ! $ads || ! periodExists(input('period')) ) {
    abort();
}

if( $ads->is_free() && ! $ads->is_expired() ) {
    abort();
}

if($ads->is_expired() && ! inputs()->not_empty('plan')) {
    abort();
}

$plan_for_url = 0;
if($ads->is_expired()) {
    $current_plan = $Plan->byId(input('plan'));
    $plan_for_url = $current_plan->ID;
} else {
    $current_plan = $Plan->byId($ads->ADS_TYPE);
}

if( ! $current_plan ) {
    abort();
}

$period     = input('period');
$discount   = periodDiscount($period);
$price      = $current_plan->discount($period, $discount);

if (isPost() && isAjax() && input('action') == 'pay') {
    $ajax_response = include('process/account/_ajax_payment_extend.php');

    return $ajax_response;
}

$js_variables = [
    'gateway_url' => $ads->extendItemLink($period, $plan_for_url) . '&action=pay'
];

$breadcrumbs = [
    _e('MY_ACCOUNT', true) => dashboardLink(),
    _e('MY_ITEMS', true) => myListingsLink(),
    _e('ADS_EXTENSION', true) => ''
];