<?php

use App\Ads;
use App\CategoryList;
use App\CustomFields;
use App\LocationList;
use App\Tag;

$Ads  = new Ads();
$Tags = new Tag();
$CustomFields = new CustomFields();
$CategoryList = new CategoryList();
$LocationList = new LocationList();

/** @var string $page_parameter :: came from page url */
$ads = $Ads->ads_by_id($page_parameter, false);

if( ! $ads || ! $loggedUser->owns($ads)) {
    abort();
}

$current_plan   = $Ads->plan_by_id($ads->ADS_TYPE);
$custom_fields  = $CustomFields->getFieldsForAds($ads);
$categories     = $CategoryList->categories();
$states         = $LocationList->states();
$is_disable     = $ads->is_active() ? "readonly" : "";

$ads_images = false;
$ads_images_count = 0;
$preuploaded_images_names = [];
if( ! $ads->is_text() && $current_plan->MAX_IMG_COUNT > 0 ) {
    $ads_images = $ads->images('thumb', true, false);
    $ads_images_count = ($ads_images) ? count($ads_images) : 0;

    for ($i = 1; $i <= $current_plan->MAX_IMG_COUNT; $i++) {
        $preuploaded_images_names[] = [
            'id' => $i,
            'name' => removeExtension(basename(removeSizeFromImageName($ads_images[$i - 1])))
        ];
    }
}

if(isPost() && isAjax()) {
    $ajax_response = include('process/account/_ajax_update_item.php');

    return $ajax_response;
}

$current_category = $current_subcategory = $current_subsidiary = $current_state = $current_city = $has_category_filter = $has_location_filter = false;

$subcategory = $CategoryList->findSubcategory($ads->SUBCAT_ID);
$current_category = $CategoryList->findCategory($subcategory->parentCategoryId());

$current_subcategory = $subcategory;
if ($subcategory->parentSubcategory()) {
    $current_subsidiary = $subcategory;
    $current_subcategory = $subcategory->parentSubcategory();
}
$has_category_filter = ($current_subsidiary) ? $current_subsidiary->name() : $current_subcategory->name();


$current_city = $LocationList->findCity($ads->CITY_ID);
$current_state = $LocationList->findState($ads->STATE_ID);
$has_location_filter = ($current_city && $current_state) ? $current_city->name() : false;

$tags = $ads->tags();

$js_variables = [
    'images_count' => $current_plan->MAX_IMG_COUNT,
    'preuploaded_images_count' => $ads_images_count,
    'preuploaded_images_names' => json_encode($preuploaded_images_names),
    'default_lat' => ! empty($ads->LATITUDE) ? $ads->LATITUDE : setting('DEFAULT_LAT'),
    'default_long' => ! empty($ads->LONGITUDE) ? $ads->LONGITUDE : setting('DEFAULT_LONG')
];

$breadcrumbs = [
    _e('MY_ACCOUNT', true) => dashboardLink(),
    _e('MY_ITEMS', true) => myListingsLink(),
    _e('EDIT_ADS', true) => ''
];
