<?php

use App\Ads;
use App\Plan;

$Ads = new Ads();
$Plan = new Plan();

/** @var mixed $page_parameter :: came from page url */
$ads = $Ads->ads_by_id($page_parameter, false);

$new_plan = $Plan->byId(input('plan'));

/** @var App\User $loggedUser */
if (! $ads || ! $new_plan || ! $loggedUser->owns($ads)) {
    abort();
}

if ($new_plan->isFree() || $new_plan->ID == $ads->PLAN_ID) {
    redirect(myListingsLink());
}

if (isPost() && isAjax() && input('action') == 'pay') {
    $ajax_response = include('process/account/_ajax_payment_change_plan.php');

    return $ajax_response;
}

$js_variables = [
    'gateway_url' => $ads->changePlanLink($new_plan->ID) . '&action=pay'
];

$breadcrumbs = [
    _e('MY_ACCOUNT', true) => dashboardLink(),
    _e('MY_ITEMS', true) => myListingsLink(),
    _e('CHANGE_PLAN', true) => ''
];