<?php

use App\Ads;

$accepted_actions_type = ['mutate', 'delete'];
$action_type = input('type');

if (!isPost() || !token()->check() || !in_array($action_type, $accepted_actions_type)) {
    session()->error(_e('WRONG_CSRF_TOKEN', true));
    redirect('refer');
}

/** @var mixed $page_parameter :: came from page url */
$ads = (new Ads())->ads_by_id($page_parameter, false);

if (!$ads || !$loggedUser->owns($ads) || $ads->updateCountLeft() == 0) {
    abort();
}

try {
    if ($action_type === 'mutate') {
        $ads->mutate();
        session()->alert('success', _e('MUTATE_SUCCESS', true, ['{%1%}' => $ads->ADS_ID]));
    }

    if ($action_type === 'delete') {
        $ads->softDelete();
        session()->alert('success', _e('DELETE_SUCCESS', true, ['{%1%}' => $ads->ADS_ID]));
    }
} catch (Exception $e) {
    session()->alert('error', _e('OPERATION_FAILED', true));
}

redirect('refer');