<?php

use App\Affiliate;

if (setting('ENABLE_REFERAL_SYSTEM') !== 'YES') {
    abort();
}

$Affiliate = new Affiliate();

if(inputs()->exists('get') && input('action') == 'withdrawal') {
    include('process/account/_withdrawal_request.php');

    return false;
}

$affiliates = currentUser()->affiliates();

$breadcrumbs = [
    _e('MY_ACCOUNT', true) => dashboardLink(),
    _e('EARN_MONEY', true) => affiliateBannersLink(),
    _e('MY_EARNINGS', true) => ''
];

$referred_user_count = currentUser()->referedUsersCount()->TOTAL;
$suspended_commision = $Affiliate->userSuspendedCommision(currentUser()->USER_ID)->TOTAL;
$active_commision = $Affiliate->userActiveCommision(currentUser()->USER_ID)->TOTAL;
$settled_commision = $Affiliate->userSettledCommision(currentUser()->USER_ID)->TOTAL;