<?php
if (isset($current_page) && ! empty($current_page)) {
    $page_title = $page_title ?: pageTitle($current_page);
    $page_description = $page_description ?: pageDescription($current_page);
    $page_keywords = $page_keywords ?: pageKeywords($current_page);
}
if (! isset($page_title)) {
    $page_title = setting('SEO_TITLE');
}
if (! isset($page_keywords)) {
    $page_keywords = setting('SEO_KEYWORDS');
}
if (! isset($page_description)) {
    $page_description = setting('SEO_DESCRIPTION');
}

$author = isset($page_author) ? $page_author : setting('SITE_AUTHOR');
?>
<!DOCTYPE html>
<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">

    <title><?= $page_title ?></title>

    <?php if (isset($current_page->getOptions()->no_index) && $current_page->getOptions()->no_index) : ?>
        <meta name="robots" content="noindex">
    <?php endif; ?>
    <?php if (isDemoMode() || (isset($no_index) && $no_index)) : ?>
        <meta name="robots" content="noindex">
    <?php endif; ?>

    <meta name="keywords" content="<?= $page_keywords ?>">
    <meta name="description" content="<?= $page_description ?>">
    <meta name="author" content="<?= $author ?>">
    <meta name="application-name" content="koClassified" data-details="<?= setting('SITE_VERSION') ?>"/>

    <?php if (! isset($current_page->getOptions()->set_base) || $current_page->getOptions()->set_base) : ?>
        <base href="<?= siteroot() ?>">
    <?php endif; ?>

    <?php
    if (isset($open_graph_settings) && count($open_graph_settings) > 0) :
        foreach ($open_graph_settings as $open_graph_key => $open_graph_value) :
            echo "<meta name='{$open_graph_key}' content='{$open_graph_value}'/>\r\n";
        endforeach;
    endif;
    ?>

    <?php if (isset($page_canonical_link)) : ?>
        <link rel="canonical" href="<?= $page_canonical_link ?>">
    <?php endif; ?>
    <?php if (isset($page_prev_link)) : ?>
        <link rel="prev" href="<?= $page_prev_link ?>">
    <?php endif; ?>
    <?php if (isset($page_next_link)) : ?>
        <link rel="next" href="<?= $page_next_link ?>">
    <?php endif; ?>

    <?php include 'includes/theme/styles.php' ?>

    <?php include 'includes/core/favicon.php' ?>

<?php
if ($current_page->getOptions()->css_files) :
    foreach ($current_page->getOptions()->css_files as $file) :
?>
<link href="<?= $file ?>" rel="stylesheet" type="text/css">
<?php
    endforeach;
endif;
?>

<?php if (isset($current_page) && $current_page->shouldLoadToastr()) : ?>
<link href="public/lib/toastr/toastr.min.css" rel="stylesheet">
<?php endif; ?>

<?php
if (isset($load_after_main_style) && is_array($load_after_main_style)) {
    foreach ($load_after_main_style as $style) {
echo "<link rel='stylesheet' href='{$style}'> \n";
    }
}
?>

<?php if ($current_page->getOptions()->has_map && isLeafletMaps() && ! isNeshanMaps()) : ?>
<link rel="stylesheet" href="node_modules/leaflet/dist/leaflet.css" integrity="sha512-puBpdR0798OZvTTbP4A8Ix/l+A4dHDD0DGqYW6RQ+9jxkRFclaxxQb/SJAWZfWAkuyeQUytO7+7N4QKrDh+drA==" crossorigin=""/>
<?php endif; ?>

<?php if ($current_page->getOptions()->has_map && isNeshanMaps()) : ?>
<link rel="stylesheet" type="text/css" href="public/lib/neshan-maps/neshan-leaflet.css">
<?php endif; ?>

</head>
