<?php
use App\MenuMain;

$menu_id = 0;
if (isset($current_page)) {
    $Menu = new MenuMain();
    $menu_id = optional($Menu->findByPage($current_page))->id;
}

/**@var App\Page $current_page */
?>

<script>
    var isLtr = "<?php echo (is_ltr() == true) ? 'yes' : 'no'; ?>";
    var menu_id = "<?php echo $menu_id ?>";
    var ajax_locations_route = "<?php echo ajaxRoute('locations') ?>";
    var Globe__captcha_type = "<?php echo setting('CAPTCHA_TYPE'); ?>";
    var Globe__captcha_route = "<?php echo ajaxRoute('captcha') ?>";
    var GLOBE__maps_source = "<?php echo setting('MAP__SOURCE') ?>";
    var GLOBE__site_url = "<?php echo siteroot() ?>";
    var Globe__popup = "<?php echo shouldShowPopup(); ?>";

    <?php
    if (isset($js_variables) && count($js_variables) > 0) {
        foreach ($js_variables as $js_variable_name => $js_variable_value) {
            echo "var {$js_variable_name} = '{$js_variable_value}'; \n\r";
        }
    }
    ?>
</script>

<script src="public/core/js/scripts/helpers.min.js"></script>

<script>
    highlightMenu(menu_id);
</script>

<?php if (isDemoMode()) : ?>
    <script>
        handleDemoGear()
    </script>
<?php endif; ?>

<?php if ($current_page->getOptions()->has_map) : ?>
    <?php if (isGoogleMaps()) : ?>
        <script src="<?= $protocol ?>maps.google.com/maps/api/js?key=<?= setting('GOOGLE_MAP_API_KEY') ?>&libraries=places&language=fa-IR"></script>
    <?php endif; ?>

    <?php if (isLeafletMaps() && ! isNeshanMaps()) : ?>
        <script src="node_modules/leaflet/dist/leaflet.js" integrity="sha512-nMMmRyTVoLYqjP9hrbed9S+FzjZHW5gY1TWCHA5ckwXZBadntCNs8kEqAWdrb9O7rxbCaA4lKTIWjDXZxflOcA==" crossorigin=""></script>
    <?php endif; ?>

    <?php if (isNeshanMaps()) : ?>
        <script src="public/lib/neshan-maps/neshan-leaflet.js" type="text/javascript"></script>
    <?php endif; ?>

    <script src="public/core/js/scripts/map.min.js"></script>
    <script>
        if (isCedarMaps) {
            var GLOBE__cedar_token = "<?php echo setting('MAP__CEDAR_API_TOKEN') ?>";
        }
        if (isNeshanMaps()) {
            var GLOBE__neshan_token = "<?php echo setting('MAP__NESHAN_API_TOKEN') ?>";
        }
    </script>
<?php endif; ?>


<?php if (isset($current_page) && $current_page->shouldLoadLanguage()) : ?>
    <script type="text/javascript" src="public/lib/toastr/toastr.min.js"></script>

    <script>
        var GLOBE__language = <?php echo json_encode($language); ?>;
    </script>
<?php endif; ?>

<?php if ($current_page->getOptions()->js_validation) : ?>
<script type="text/javascript" src="public/core/js/scripts/validation.min.js"></script>
<?php endif; ?>
<?php if ($current_page->getOptions()->js_validation && isRecaptcha()) : ?>
    <script>var Globe__recaptcha_key = "<?php echo setting('RECAPTCHA_SITE_KEY') ?>"</script>
    <script src='https://www.google.com/recaptcha/api.js?hl=<?= lang() ?>&onload=CaptchaCallback&render=explicit'></script>
<?php endif; ?>

<?php if ($current_page->getOptions()->has_upload) : ?>
    <script type="text/javascript" src="public/lib/simple-ajax-uploader/SimpleAjaxUploader.min.js"></script>
    <script type="text/javascript" src="public/core/js/scripts/upload.min.js"></script>
<?php endif; ?>

<?php
if ($current_page->getOptions()->js_files) :
    foreach ($current_page->getOptions()->js_files as $file) :
?>
<script type="text/javascript" src="<?= $file ?>"></script>
<?php
    endforeach;
endif;
?>