<?php

use App\PageList;
use App\User;

$page_slug = $page_slug ?: input('slug');
$current_page = (new PageList())->findInFront($page_slug);

$User = new User();

if (! session()->exists('SESS_USER_ID') && cookie()->exists('random_hash')) {
    $user = $User->findByCookie();
    if ($user) {
        $user->login();
    }
}

$loggedUser = $User->findById(session()->get('SESS_USER_ID'));

// go to activation if user is not activated
if ($loggedUser && $loggedUser->isPendingActivation() && registerNeedsActivation() && shouldRedirectToActivationPage($current_page)) {

    if (canActivateWithEmail() && $loggedUser->hasAnyEmailForActivation()) {
        redirect(emailActivationLink());
    }
    if (canActivateWithSMS() && $loggedUser->hasAnyMobileForActivation()) {
        redirect(smsActivationLink());
    }
    if (isActivateWithOnlyEmail()) {
        redirect(emailActivationLink());
    }
    if (isActivateWithOnlySms()) {
        redirect(smsActivationLink());
    }

    redirect(emailActivationLink());
}

if (! $loggedUser || ! $loggedUser->hasCorrectAccessLevel()) {
    $loggedUser = null;
}
if ( (! $loggedUser || ! $loggedUser->hasCorrectAccessLevel()) &&  isset($current_page) && $current_page->getOptions()->account_page) {
    $User->logOut();
    redirect('auth');
}

// maintenance mode
if (setting('MAINTENANCE_MODE') === "ON" && (!isset($pageType) || $pageType != 'maintenance')) {
    if (!$loggedUser || $loggedUser->isCommonUser()) {
        $now = time();
        $reopen = DateTime::createFromFormat('Y-m-d H:i:s', setting('REOPEN_DATE'));
        $reopen_timestamp = $reopen->format('U');

        if ($reopen_timestamp > $now) {
            redirect(siteroot() . 'maintenance');
        }
    }
}

if (isDemoMode() && $current_page && inputs()->not_empty('stylizer-form')) {
    $settings = $current_page->settings();
    $inputs = inputs()->startsWith('setting__');

    foreach ($settings as $key => $setting) {
        if (array_key_exists($setting->key, $inputs)) {

            $settings[$key]->value = $inputs[$setting->key];
        }
    }

    $current_page->_fetched_settings = $settings;
}