<?php

namespace App\Widget;

use App\Link;

class LinksWidget extends Widget
{
    protected $slug = 'site-links';

    protected $fields = [
        [ 'slug' => 'widget_title', 'type' => 'text', 'title' => 'عنوان ابزارک', 'default_value' => 'لینک های سایت', 'description'=> 'در صورت خالی بودن، بخش عنوان نمایش داده نخواهد شد'],
        [ 'slug' => 'links_count', 'type' => 'text', 'title' => 'تعداد لینک های قابل نمایش', 'default_value' => 6, 'description'=> 'در صورت خالی بودن، تمام موارد نمایش داده خواهد شد']
    ];

    public function render(){
        $links = (new Link())->all($this->setting('links_count'));
        $widget = $this;

        include($this->viewPath());
        return true;
    }
}