<?php

namespace App\Widget;


use App\Post;
use App\PostCategory;

class BlogCategoriesWidget extends Widget
{
    protected $slug = 'blog-categories';

    protected $fields = [
        [ 'slug' => 'widget_title', 'type' => 'text', 'title' => 'عنوان ابزارک', 'default_value' => 'گروه بندی مطالب', 'description'=> 'در صورت خالی بودن، بخش عنوان نمایش داده نخواهد شد'],
        [ 'slug' => 'show_post_count', 'type' => 'boolean', 'title' => 'نمایش تعداد پست های هر دسته', 'default_value' => 'NO']
    ];

    public function render(){
        $categories = (new PostCategory())->all(true);
        if ($this->setting('show_post_count') === 'YES') {
            $all_posts_count = (new Post())->countAllPosts();
        }
        $widget = $this;

        include($this->viewPath());
        return true;
    }
}