<?php
namespace App\Widget;

use App\Banner;

class BannersWidget extends Widget {

    protected $slug = 'banners';

    protected $fields = [
        [ 'slug' => 'widget_title', 'type' => 'text', 'title' => 'عنوان ابزارک', 'default_value' => 'بنرهای سایدبار', 'description'=> 'در صورت خالی بودن، بخش عنوان و کادر اطراف بنرها نمایش داده نخواهد شد'],
        [ 'slug' => 'count', 'type' => 'text', 'title' => 'حداکثر تعداد بنرها', 'default_value' => 0, 'description'=> 'مقدار صفر به معنای نمایش تمام بنرهای سایدبار است'],
    ];

    public function render(){
        $banners = (new Banner())->forSidebar($this->setting('count'));
        $widget = $this;

        if ($banners) {
            include($this->viewPath());
        }

        return true;
    }
}