<?php
namespace App\Widget;

use App\Banner;

class BannersForCategoriesWidget extends Widget {

    protected $slug = 'banners-by-id';

    public $category_id;

    public $subcategory_id;

    public $subsidiary_id;

    protected $fields = [
        [ 'slug' => 'widget_title', 'type' => 'text', 'title' => 'عنوان ابزارک', 'default_value' => 'بنرهای سایدبار', 'description'=> 'در صورت خالی بودن، بخش عنوان و کادر اطراف بنرها نمایش داده نخواهد شد'],
        [ 'slug' => 'count', 'type' => 'text', 'title' => 'حداکثر تعداد بنرها', 'default_value' => 0, 'description'=> 'مقدار صفر به معنای نمایش تمام بنرهای سایدبار است'],
    ];

    public function render() {
        $banners = (new Banner())->forSidebar($this->setting('count'), $this->category_id, $this->subcategory_id, $this->subsidiary_id);
        $widget = $this;

        if ($banners) {
            include($this->viewPath());
        }

        return true;
    }

    /**
     * Returns path to view file
     *
     * @return mixed
     */
    protected function viewPath() {
        return "includes/theme/widgets/banners.php";
    }
}